/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import java.sql.SQLException;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.NotEqualOrNullFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NegativeServiceFilter
extends NotEqualOrNullFilter<Integer> {
    public static final String TYPE = "servicenot";
    protected int serviceId;

    public NegativeServiceFilter(int serviceId) {
        super(TYPE, SQLType.INT, "EVENTS.SERVICEID", "serviceType.id", serviceId);
    }

    @Override
    public String getTextDescription() {
        String serviceName = Integer.toString(this.getServiceId());
        try {
            serviceName = NetworkElementFactory.getServiceNameFromId(this.getServiceId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return "service is not " + serviceName;
    }

    @Override
    public String toString() {
        return "<WebEventRepository.NegativeServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

