/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import java.util.Arrays;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.SortStyle;
import org.opennms.web.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCriteria {
    Filter[] m_filters = null;
    SortStyle m_sortStyle = SortStyle.TIME;
    AcknowledgeType m_ackType = AcknowledgeType.UNACKNOWLEDGED;
    int m_offset = -1;
    int m_limit = -1;

    public EventCriteria(Filter ... filters) {
        this(filters, null, null, -1, -1);
    }

    public EventCriteria(AcknowledgeType ackType, Filter[] filters) {
        this(filters, null, ackType, -1, -1);
    }

    public EventCriteria(Filter[] filters, SortStyle sortStyle, AcknowledgeType ackType, int limit, int offset) {
        this.m_filters = filters;
        this.m_sortStyle = sortStyle;
        this.m_ackType = ackType;
        this.m_limit = limit;
        this.m_offset = offset;
    }

    public <E extends Exception> void visit(EventCriteriaVisitor<E> visitor) throws E {
        if (this.m_ackType != null) {
            visitor.visitAckType(this.m_ackType);
        }
        for (Filter filter : this.m_filters) {
            visitor.visitFilter(filter);
        }
        if (this.m_sortStyle != null) {
            visitor.visitSortStyle(this.m_sortStyle);
        }
        if (this.m_limit > 0 && this.m_offset > -1) {
            visitor.visitLimit(this.m_limit, this.m_offset);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("filters", Arrays.asList(this.m_filters)).append("sortStyle", (Object)this.m_sortStyle).append("ackType", (Object)this.m_ackType).append("limit", this.m_limit).append("offset", this.m_offset).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseEventCriteriaVisitor<E extends Exception>
    implements EventCriteriaVisitor<E> {
        @Override
        public void visitAckType(AcknowledgeType ackType) throws E {
        }

        @Override
        public void visitFilter(Filter filter) throws E {
        }

        @Override
        public void visitLimit(int limit, int offset) throws E {
        }

        @Override
        public void visitSortStyle(SortStyle sortStyle) throws E {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EventCriteriaVisitor<E extends Exception> {
        public void visitAckType(AcknowledgeType var1) throws E;

        public void visitFilter(Filter var1) throws E;

        public void visitSortStyle(SortStyle var1) throws E;

        public void visitLimit(int var1, int var2) throws E;
    }
}

