/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.HashMap;
import java.util.Map;

public class Vlan {
    int m_nodeId;
    int m_vlanId;
    String m_vlanname;
    int m_vlantype;
    int m_vlanstatus;
    String m_lastPollTime;
    char m_status;
    private static final String[] VLAN_TYPE = new String[]{"&nbsp;", "Ethernet", "FDDI", "TokenRing", "FDDINet", "TRNet", "Deprecated"};
    private static final String[] VLAN_STATUS = new String[]{"&nbsp;", "operational", "suspendid", "mtuTooBigForDevice", "mtuTooBigForTrunk"};
    private static final Map<Character, String> statusMap = new HashMap<Character, String>();

    Vlan() {
    }

    Vlan(int nodeId, int vlanid, String vlanname, int vlantype, int vlanstatus, String lastpolltime, char status) {
        this.m_nodeId = nodeId;
        this.m_vlanId = vlanid;
        this.m_vlanname = vlanname;
        this.m_vlantype = vlantype;
        this.m_vlanstatus = vlanstatus;
        this.m_lastPollTime = lastpolltime;
        this.m_status = status;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Vlan id = " + this.m_vlanId + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public String getLastPollTime() {
        return this.m_lastPollTime;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public char getStatus() {
        return this.m_status;
    }

    public String getStatusString() {
        return statusMap.get(new Character(this.m_status));
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_vlanId == 0) {
            return "";
        }
        if (this.m_vlanId == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_vlanId * redoffset) % 255;
        green = (green + this.m_vlanId * greenoffset) % 255;
        blue = (blue + this.m_vlanId * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    public int getVlanId() {
        return this.m_vlanId;
    }

    public String getVlanName() {
        return this.m_vlanname;
    }

    public int getVlanStatus() {
        return this.m_vlanstatus;
    }

    public String getVlanStatusString() {
        return VLAN_STATUS[this.m_vlanstatus];
    }

    public int getVlanType() {
        return this.m_vlantype;
    }

    public String getVlanTypeString() {
        return VLAN_TYPE[this.m_vlantype];
    }

    static {
        statusMap.put(new Character('A'), "Active");
        statusMap.put(new Character(' '), "Unknown");
        statusMap.put(new Character('D'), "Deleted");
        statusMap.put(new Character('N'), "Not Active");
    }
}

