/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.MissingParameterException;
import org.opennms.web.Util;
import org.opennms.web.WebSecurityUtils;

public class NodeRescanServlet
extends HttpServlet {
    private static final long serialVersionUID = -3183139374532183137L;
    protected EventProxy proxy;

    public void init() throws ServletException {
        try {
            this.proxy = Util.createEventProxy();
        }
        catch (Exception e) {
            throw new ServletException("Exception", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String returnUrl = request.getParameter("returnUrl");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "returnUrl"});
        }
        if (returnUrl == null) {
            throw new MissingParameterException("returnUrl", new String[]{"node", "returnUrl"});
        }
        try {
            int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
            Event outEvent = new Event();
            outEvent.setSource("NodeRescanServlet");
            outEvent.setUei("uei.opennms.org/internal/capsd/forceRescan");
            outEvent.setNodeid((long)nodeId);
            outEvent.setHost("host");
            outEvent.setTime(EventConstants.formatToString((Date)new Date()));
            this.proxy.send(outEvent);
            response.sendRedirect(Util.calculateUrlBase(request) + "/" + returnUrl);
        }
        catch (Exception e) {
            throw new ServletException("Exception sending node rescan event", (Throwable)e);
        }
    }
}

