/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.IPSorter;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.Util;
import org.opennms.web.element.AtInterface;
import org.opennms.web.element.DataLinkInterface;
import org.opennms.web.element.Interface;
import org.opennms.web.element.IpRouteInterface;
import org.opennms.web.element.Node;
import org.opennms.web.element.Service;
import org.opennms.web.element.StpInterface;
import org.opennms.web.element.StpNode;
import org.opennms.web.element.Vlan;
import org.opennms.web.svclayer.AggregateStatus;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkElementFactory {
    protected static Map<String, Integer> serviceName2IdMap;
    protected static Map<Integer, String> serviceId2NameMap;
    private static final Comparator<Interface> INTERFACE_COMPARATOR;

    private NetworkElementFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeLabel(int nodeId) throws SQLException {
        String label = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT NODELABEL FROM NODE WHERE NODEID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                label = rs.getString("NODELABEL");
            }
        }
        finally {
            d.cleanUp();
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIpPrimaryAddress(int nodeId) throws SQLException {
        String label = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT IPADDR FROM ipinterface WHERE NODEID = ? and isSnmpPrimary='P'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                label = rs.getString("IPADDR");
            }
        }
        finally {
            d.cleanUp();
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node getNode(int nodeId) throws SQLException {
        Node node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE NODEID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Node[] nodes = NetworkElementFactory.rs2Nodes(rs);
            if (nodes.length > 0) {
                node = nodes[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getAllNodes() throws SQLException {
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT * FROM NODE WHERE NODETYPE != 'D' ORDER BY NODELABEL");
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesLike(String nodeLabel) throws SQLException {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        nodeLabel = nodeLabel.toLowerCase();
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(nodeLabel);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE LOWER(NODELABEL) LIKE ? AND NODETYPE != 'D' ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithIpLike(String iplike) throws SQLException {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT node.* FROM NODE, IPINTERFACE WHERE NODE.NODEID=IPINTERFACE.NODEID AND IPLIKE(IPINTERFACE.IPADDR,?) AND IPINTERFACE.ISMANAGED != 'D' AND node.NODETYPE != 'D' ORDER BY node.NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, iplike);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithService(int serviceId) throws SQLException {
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE NODEID IN (SELECT NODEID FROM IFSERVICES WHERE SERVICEID=?) AND NODETYPE != 'D' ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setInt(1, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithPhysAddr(String macAddr) throws SQLException {
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(macAddr);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT * FROM node WHERE nodetype != 'D' AND (nodeid IN (SELECT nodeid FROM snmpinterface WHERE snmpphysaddr LIKE ? ) OR  nodeid IN (SELECT nodeid FROM atinterface WHERE atphysaddr LIKE ? )) ORDER BY nodelabel");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            stmt.setString(2, buffer.toString());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithPhysAddrAtInterface(String macAddr) throws SQLException {
        if (macAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(macAddr);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT * FROM node WHERE nodetype != 'D' AND nodeid IN (SELECT nodeid FROM atinterface WHERE atphysaddr LIKE '% ? %') ORDER BY nodelabel");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithPhysAddrFromSnmpInterface(String macAddr) throws SQLException {
        if (macAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(macAddr);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT * FROM node WHERE nodetype != 'D' AND nodeid IN (SELECT nodeid FROM snmpinterface WHERE snmpphysaddr LIKE '% ? %') ORDER BY nodelabel");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithIfAlias(String ifAlias) throws SQLException {
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(ifAlias);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE NODEID IN (SELECT SNMPINTERFACE.NODEID FROM SNMPINTERFACE,IPINTERFACE WHERE SNMPINTERFACE.SNMPIFALIAS ILIKE ? AND SNMPINTERFACE.SNMPIFINDEX=IPINTERFACE.IFINDEX AND IPINTERFACE.NODEID=SNMPINTERFACE.NODEID AND IPINTERFACE.ISMANAGED != 'D') AND NODETYPE != 'D' ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostname(String ipAddress) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String hostname = ipAddress;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT IPADDR, IPHOSTNAME FROM IPINTERFACE WHERE IPADDR=? AND IPHOSTNAME IS NOT NULL");
            d.watch((Object)stmt);
            stmt.setString(1, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                hostname = rs.getString("IPHOSTNAME");
            }
        }
        finally {
            d.cleanUp();
        }
        return hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface getInterface(int ipInterfaceId) throws SQLException {
        Interface intf = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE ID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, ipInterfaceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Interface[] intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
            if (intfs.length > 0) {
                intf = intfs[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface getInterface(int nodeId, String ipAddress) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Interface intf = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE NODEID = ? AND IPADDR=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Interface[] intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
            if (intfs.length > 0) {
                intf = intfs[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface getInterface(int nodeId, String ipAddress, int ifindex) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Interface intf = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE NODEID = ? AND IPADDR=? AND IFINDEX=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            stmt.setInt(3, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Interface[] intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
            if (intfs.length > 0) {
                intf = intfs[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface getSnmpInterface(int nodeId, int ifIndex) throws SQLException {
        Interface intf = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM SNMPINTERFACE WHERE NODEID = ? AND SNMPIFINDEX=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setInt(2, ifIndex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Interface[] intfs = NetworkElementFactory.rs2SnmpInterfaces(rs);
            if (intfs.length > 0) {
                intf = intfs[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getInterfacesWithIpAddress(String ipAddress) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE IPADDR=?");
            d.watch((Object)stmt);
            stmt.setString(1, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getInterfacesWithIfAlias(int nodeId, String ifAlias) throws SQLException {
        if (ifAlias == null) {
            throw new IllegalArgumentException("Cannot take null parameter ifAlias");
        }
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(ifAlias);
            buffer.append("%");
            PreparedStatement stmt = null;
            if (nodeId > 0) {
                stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE NODEID = ? AND IFINDEX IN (SELECT SNMPIFINDEX FROM SNMPINTERFACE WHERE SNMPIFALIAS ILIKE ? AND IPINTERFACE.NODEID=SNMPINTERFACE.NODEID) AND ISMANAGED != 'D'");
                d.watch((Object)stmt);
                stmt.setInt(1, nodeId);
                stmt.setString(2, buffer.toString());
            } else {
                stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE IPINTERFACE.IFINDEX IN (SELECT SNMPIFINDEX FROM SNMPINTERFACE WHERE SNMPIFALIAS ILIKE ? AND IPINTERFACE.NODEID=SNMPINTERFACE.NODEID) AND IPINTERFACE.ISMANAGED != 'D' ORDER BY IPINTERFACE.NODEID");
                d.watch((Object)stmt);
                stmt.setString(1, buffer.toString());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nodeHasIfAliases(int nodeId) throws SQLException {
        boolean hasAliases = false;
        if (nodeId > 0) {
            DBUtils d = new DBUtils(NetworkElementFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement("SELECT ID FROM IPINTERFACE WHERE NODEID = ? AND IFINDEX IN (SELECT SNMPIFINDEX FROM SNMPINTERFACE WHERE SNMPIFALIAS ILIKE '%_%' AND IPINTERFACE.NODEID=SNMPINTERFACE.NODEID) AND ISMANAGED != 'D'");
                d.watch((Object)stmt);
                stmt.setInt(1, nodeId);
                ResultSet rs = stmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    hasAliases = true;
                }
            }
            finally {
                d.cleanUp();
            }
        }
        return hasAliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getAllInterfacesOnNode(int nodeId) throws SQLException {
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE NODEID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getAllSnmpInterfacesOnNode(int nodeId) throws SQLException {
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM SNMPINTERFACE WHERE NODEID = ? ORDER BY SNMPIFINDEX");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2SnmpInterfaces(rs);
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getActiveInterfacesOnNode(int nodeId) throws SQLException {
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPINTERFACE WHERE NODEID = ? AND ISMANAGED != 'D' ORDER BY IFINDEX");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2Interfaces(rs);
            NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    public static Interface[] getAllInterfaces() throws SQLException {
        return NetworkElementFactory.getAllInterfaces(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interface[] getAllInterfaces(boolean includeSNMP) throws SQLException {
        Interface[] intfs = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT * FROM IPINTERFACE ORDER BY IPHOSTNAME, NODEID, IPADDR");
            d.watch((Object)rs);
            intfs = NetworkElementFactory.rs2Interfaces(rs);
            if (includeSNMP) {
                NetworkElementFactory.augmentInterfacesWithSnmpData(intfs, conn);
            }
        }
        finally {
            d.cleanUp();
        }
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service getService(int nodeId, String ipAddress, int serviceId) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Service service = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID=SERVICE.SERVICEID AND IFSERVICES.NODEID=? AND IFSERVICES.IPADDR=? AND IFSERVICES.SERVICEID=? ORDER BY IFSERVICES.STATUS");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            stmt.setInt(3, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Service[] services = NetworkElementFactory.rs2Services(rs);
            if (services.length > 0) {
                service = services[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service getService(int ifServiceId) throws SQLException {
        Service service = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID=SERVICE.SERVICEID AND IFSERVICES.ID=? ORDER BY IFSERVICES.STATUS");
            d.watch((Object)stmt);
            stmt.setInt(1, ifServiceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Service[] services = NetworkElementFactory.rs2Services(rs);
            if (services.length > 0) {
                service = services[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service[] getAllServices() throws SQLException {
        Service[] services = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID = SERVICE.SERVICEID ORDER BY SERVICE.SERVICEID, inet(IFSERVICES.IPADDR)");
            d.watch((Object)rs);
            services = NetworkElementFactory.rs2Services(rs);
        }
        finally {
            d.cleanUp();
        }
        return services;
    }

    public static Service[] getServicesOnInterface(int nodeId, String ipAddress) throws SQLException {
        return NetworkElementFactory.getServicesOnInterface(nodeId, ipAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service[] getServicesOnInterface(int nodeId, String ipAddress, boolean includeDeletions) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Service[] services = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID=SERVICE.SERVICEID AND IFSERVICES.NODEID=? AND IFSERVICES.IPADDR=?");
            if (!includeDeletions) {
                buffer.append(" AND IFSERVICES.STATUS <> 'D'");
            }
            PreparedStatement stmt = conn.prepareStatement(buffer.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            services = NetworkElementFactory.rs2Services(rs);
        }
        finally {
            d.cleanUp();
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service[] getServicesOnNode(int nodeId) throws SQLException {
        Service[] services = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID=SERVICE.SERVICEID AND IFSERVICES.NODEID=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            services = NetworkElementFactory.rs2Services(rs);
        }
        finally {
            d.cleanUp();
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service[] getServicesOnNode(int nodeId, int serviceId) throws SQLException {
        Service[] services = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT IFSERVICES.*, SERVICE.SERVICENAME FROM IFSERVICES, SERVICE WHERE IFSERVICES.SERVICEID=SERVICE.SERVICEID AND IFSERVICES.NODEID=? AND IFSERVICES.SERVICEID=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setInt(2, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            services = NetworkElementFactory.rs2Services(rs);
        }
        finally {
            d.cleanUp();
        }
        return services;
    }

    protected static Node[] rs2Nodes(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs parameter cannot be null");
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        while (rs.next()) {
            String nodeType;
            Integer nodeParentID;
            Node node = new Node();
            node.m_nodeId = rs.getInt("nodeId");
            node.m_dpname = rs.getString("dpName");
            Timestamp timestamp = rs.getTimestamp("nodeCreateTime");
            if (timestamp != null) {
                node.m_nodeCreateTime = Util.formatDateToUIString(new Date(timestamp.getTime()));
            }
            if ((nodeParentID = Integer.valueOf(rs.getInt("nodeParentID"))) != null) {
                node.m_nodeParent = nodeParentID;
            }
            if ((nodeType = rs.getString("nodeType")) != null) {
                node.m_nodeType = nodeType.charAt(0);
            }
            node.m_nodeSysId = rs.getString("nodeSysOID");
            node.m_nodeSysName = rs.getString("nodeSysName");
            node.m_nodeSysDescr = rs.getString("nodeSysDescription");
            node.m_nodeSysLocn = rs.getString("nodeSysLocation");
            node.m_nodeSysContact = rs.getString("nodeSysContact");
            node.m_label = rs.getString("nodelabel");
            node.m_operatingSystem = rs.getString("operatingsystem");
            node.m_foreignSource = rs.getString("foreignSource");
            node.m_foreignId = rs.getString("foreignId");
            nodes.add(node);
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    protected static Interface[] rs2Interfaces(ResultSet rs) throws SQLException {
        ArrayList<Interface> intfs = new ArrayList<Interface>();
        while (rs.next()) {
            Object element = null;
            Interface intf = new Interface();
            intf.m_id = rs.getInt("id");
            intf.m_nodeId = rs.getInt("nodeid");
            intf.m_ifIndex = rs.getInt("ifIndex");
            intf.m_ipStatus = rs.getInt("ipStatus");
            intf.m_ipHostName = rs.getString("ipHostname");
            intf.m_ipAddr = rs.getString("ipAddr");
            element = rs.getString("isManaged");
            if (element != null) {
                intf.m_isManaged = ((String)element).charAt(0);
            }
            if ((element = rs.getTimestamp("ipLastCapsdPoll")) != null) {
                intf.m_ipLastCapsdPoll = Util.formatDateToUIString(new Date(((Timestamp)element).getTime()));
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    protected static Interface[] rs2SnmpInterfaces(ResultSet rs) throws SQLException {
        ArrayList<Interface> intfs = new ArrayList<Interface>();
        while (rs.next()) {
            Interface intf = new Interface();
            intf.m_nodeId = rs.getInt("nodeid");
            intf.m_ipAddr = rs.getString("ipaddr");
            intf.m_snmpIfIndex = rs.getInt("snmpifindex");
            intf.m_snmpIpAdEntNetMask = rs.getString("snmpIpAdEntNetMask");
            intf.m_snmpPhysAddr = rs.getString("snmpPhysAddr");
            intf.m_snmpIfDescr = rs.getString("snmpIfDescr");
            intf.m_snmpIfName = rs.getString("snmpIfName");
            intf.m_snmpIfType = rs.getInt("snmpIfType");
            intf.m_snmpIfOperStatus = rs.getInt("snmpIfOperStatus");
            intf.m_snmpIfSpeed = rs.getLong("snmpIfSpeed");
            intf.m_snmpIfAdminStatus = rs.getInt("snmpIfAdminStatus");
            intf.m_snmpIfAlias = rs.getString("snmpIfAlias");
            Object element = rs.getString("snmpPoll");
            if (element != null) {
                intf.m_isSnmpPoll = ((String)element).charAt(0);
            }
            if ((element = rs.getTimestamp("snmpLastCapsdPoll")) != null) {
                intf.m_snmpLastCapsdPoll = Util.formatDateToUIString(new Date(((Timestamp)element).getTime()));
            }
            if ((element = rs.getTimestamp("snmpLastSnmpPoll")) != null) {
                intf.m_snmpLastSnmpPoll = Util.formatDateToUIString(new Date(((Timestamp)element).getTime()));
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void augmentInterfacesWithSnmpData(Interface[] intfs, Connection conn) throws SQLException {
        if (intfs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i].getIfIndex() == 0) continue;
            try {
                PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM SNMPINTERFACE WHERE NODEID=? AND SNMPIFINDEX=?");
                d.watch((Object)pstmt);
                pstmt.setInt(1, intfs[i].getNodeId());
                pstmt.setInt(2, intfs[i].getIfIndex());
                ResultSet rs = pstmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    intfs[i].m_snmpIfIndex = rs.getInt("snmpifindex");
                    intfs[i].m_snmpIpAdEntNetMask = rs.getString("snmpIpAdEntNetMask");
                    intfs[i].m_snmpPhysAddr = rs.getString("snmpPhysAddr");
                    intfs[i].m_snmpIfDescr = rs.getString("snmpIfDescr");
                    intfs[i].m_snmpIfName = rs.getString("snmpIfName");
                    intfs[i].m_snmpIfType = rs.getInt("snmpIfType");
                    intfs[i].m_snmpIfOperStatus = rs.getInt("snmpIfOperStatus");
                    intfs[i].m_snmpIfSpeed = rs.getLong("snmpIfSpeed");
                    intfs[i].m_snmpIfAdminStatus = rs.getInt("snmpIfAdminStatus");
                    intfs[i].m_snmpIfAlias = rs.getString("snmpIfAlias");
                    Object element = rs.getString("snmpPoll");
                    if (element != null) {
                        intfs[i].m_isSnmpPoll = ((String)element).charAt(0);
                    }
                    if ((element = rs.getTimestamp("snmpLastCapsdPoll")) != null) {
                        intfs[i].m_snmpLastCapsdPoll = Util.formatDateToUIString(new Date(((Timestamp)element).getTime()));
                    }
                    if ((element = rs.getTimestamp("snmpLastSnmpPoll")) != null) {
                        intfs[i].m_snmpLastSnmpPoll = Util.formatDateToUIString(new Date(((Timestamp)element).getTime()));
                    }
                }
                pstmt = conn.prepareStatement("SELECT issnmpprimary FROM ipinterface WHERE nodeid=? AND ifindex=? AND ipaddr=?");
                d.watch((Object)pstmt);
                pstmt.setInt(1, intfs[i].getNodeId());
                pstmt.setInt(2, intfs[i].getIfIndex());
                pstmt.setString(3, intfs[i].getIpAddress());
                rs = pstmt.executeQuery();
                d.watch((Object)rs);
                if (!rs.next()) continue;
                intfs[i].m_isSnmpPrimary = rs.getString("issnmpprimary");
                continue;
            }
            finally {
                d.cleanUp();
            }
        }
    }

    protected static Service[] rs2Services(ResultSet rs) throws SQLException {
        ArrayList<Service> services = new ArrayList<Service>();
        while (rs.next()) {
            Service service = new Service();
            Object element = null;
            service.setId(rs.getInt("id"));
            service.setNodeId(rs.getInt("nodeid"));
            service.setIfIndex(rs.getInt("ifindex"));
            service.setIpAddress(rs.getString("ipaddr"));
            element = rs.getTimestamp("lastgood");
            if (element != null) {
                service.setLastGood(Util.formatDateToUIString(new Date(((Timestamp)element).getTime())));
            }
            service.setServiceId(rs.getInt("serviceid"));
            service.setServiceName(rs.getString("servicename"));
            element = rs.getTimestamp("lastfail");
            if (element != null) {
                service.setLastFail(Util.formatDateToUIString(new Date(((Timestamp)element).getTime())));
            }
            service.setNotify(rs.getString("notify"));
            element = rs.getString("status");
            if (element != null) {
                service.setStatus(((String)element).charAt(0));
            }
            services.add(service);
        }
        return services.toArray(new Service[services.size()]);
    }

    public static String getServiceNameFromId(int serviceId) throws SQLException {
        if (serviceId2NameMap == null) {
            NetworkElementFactory.createServiceIdNameMaps();
        }
        String serviceName = serviceId2NameMap.get(new Integer(serviceId));
        return serviceName;
    }

    public static int getServiceIdFromName(String serviceName) throws SQLException {
        Integer value;
        if (serviceName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int serviceId = -1;
        if (serviceName2IdMap == null) {
            NetworkElementFactory.createServiceIdNameMaps();
        }
        if ((value = serviceName2IdMap.get(serviceName)) != null) {
            serviceId = value;
        }
        return serviceId;
    }

    public static Map<Integer, String> getServiceIdToNameMap() throws SQLException {
        if (serviceId2NameMap == null) {
            NetworkElementFactory.createServiceIdNameMaps();
        }
        return new HashMap<Integer, String>(serviceId2NameMap);
    }

    public static Map<String, Integer> getServiceNameToIdMap() throws SQLException {
        if (serviceName2IdMap == null) {
            NetworkElementFactory.createServiceIdNameMaps();
        }
        return new HashMap<String, Integer>(serviceName2IdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createServiceIdNameMaps() throws SQLException {
        HashMap<Integer, String> idMap = new HashMap<Integer, String>();
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT SERVICEID, SERVICENAME FROM SERVICE");
            d.watch((Object)rs);
            while (rs.next()) {
                int id = rs.getInt("SERVICEID");
                String name = rs.getString("SERVICENAME");
                idMap.put(new Integer(id), name);
                nameMap.put(name, new Integer(id));
            }
        }
        finally {
            d.cleanUp();
        }
        serviceId2NameMap = idMap;
        serviceName2IdMap = nameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesLikeAndIpLike(String nodeLabel, String iplike, int serviceId) throws SQLException {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        nodeLabel = nodeLabel.toLowerCase();
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(nodeLabel);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE NODEID IN (SELECT DISTINCT NODEID FROM IFSERVICES WHERE SERVICEID = ?) AND NODETYPE != 'D' AND LOWER(NODELABEL) LIKE ? AND IPLIKE(IPINTERFACE.IPADDR,?) AND NODE.NODEID=IPINTERFACE.NODEID ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setInt(1, serviceId);
            stmt.setString(2, buffer.toString());
            stmt.setString(3, iplike);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesLike(String nodeLabel, int serviceId) throws SQLException {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        nodeLabel = nodeLabel.toLowerCase();
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer buffer = new StringBuffer("%");
            buffer.append(nodeLabel);
            buffer.append("%");
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE LOWER(NODELABEL) LIKE ? AND NODETYPE != 'D' AND NODEID IN (SELECT DISTINCT NODEID FROM IFSERVICES WHERE SERVICEID = ?) ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, buffer.toString());
            stmt.setInt(2, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesWithIpLike(String iplike, int serviceId) throws SQLException {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT * FROM NODE WHERE NODE.NODEID=IPINTERFACE.NODEID AND IPLIKE(IPINTERFACE.IPADDR,?) AND NODETYPE != 'D' AND NODEID IN (SELECT DISTINCT NODEID FROM IFSERVICES WHERE SERVICEID = ?) ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, iplike);
            stmt.setInt(2, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getAllNodes(int serviceId) throws SQLException {
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NODE WHERE NODETYPE != 'D' AND NODEID IN (SELECT DISTINCT NODEID FROM IFSERVICES WHERE SERVICEID = ?) ORDER BY NODELABEL");
            d.watch((Object)stmt);
            stmt.setInt(1, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtInterface[] getAtInterfacesFromPhysaddr(String AtPhysAddr) throws SQLException {
        if (AtPhysAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        AtInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM ATINTERFACE WHERE ATPHYSADDR LIKE '%" + AtPhysAddr + "%' AND STATUS != 'D'");
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2AtInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] getNodesFromPhysaddr(String AtPhysAddr) throws SQLException {
        if (AtPhysAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Node[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(*) FROM IPINTERFACE WHERE NODEID IN (SELECT NODEID FROM ATINTERFACE WHERE ATPHYSADDR LIKE '%" + AtPhysAddr + "%' AND STATUS != 'D'");
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2Nodes(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtInterface getAtInterface(int nodeID, String ipaddr) throws SQLException {
        if (ipaddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        AtInterface[] nodes = null;
        AtInterface node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM ATINTERFACE WHERE NODEID = ? AND IPADDR = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setString(2, ipaddr);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2AtInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        if (nodes.length > 0) {
            return nodes[0];
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpRouteInterface[] getIpRoute(int nodeID) throws SQLException {
        IpRouteInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPROUTEINTERFACE WHERE NODEID = ? AND STATUS != 'D' ORDER BY ROUTEDEST");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2IpRouteInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpRouteInterface[] getIpRoute(int nodeID, int ifindex) throws SQLException {
        IpRouteInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPROUTEINTERFACE WHERE NODEID = ? AND ROUTEIFINDEX = ? AND STATUS != 'D' ORDER BY ROUTEDEST");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2IpRouteInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isParentNode(int nodeID) throws SQLException {
        boolean isPN = false;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                isPN = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return isPN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBridgeNode(int nodeID) throws SQLException {
        boolean isPN = false;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM STPNODE WHERE NODEID = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                isPN = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return isPN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRouteInfoNode(int nodeID) throws SQLException {
        boolean isRI = false;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM IPROUTEINTERFACE WHERE NODEID = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                isRI = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return isRI;
    }

    public static DataLinkInterface[] getDataLinksOnNode(int nodeID) throws SQLException {
        DataLinkInterface[] normalnodes = null;
        normalnodes = NetworkElementFactory.getDataLinks(nodeID);
        DataLinkInterface[] parentnodes = null;
        parentnodes = NetworkElementFactory.getDataLinksFromNodeParent(nodeID);
        DataLinkInterface[] nodes = new DataLinkInterface[normalnodes.length + parentnodes.length];
        int j = 0;
        for (DataLinkInterface normalnode : normalnodes) {
            nodes[j++] = normalnode;
        }
        for (DataLinkInterface parentnode : parentnodes) {
            nodes[j++] = parentnode;
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getLinkedNodeIdOnNode(int nodeID) throws SQLException {
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        Integer node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Integer element;
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
            stmt = conn.prepareStatement("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getLinkedNodeIdOnNode(int nodeID, Connection conn) throws SQLException {
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        Integer node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Integer element;
            PreparedStatement stmt = conn.prepareStatement("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
            stmt = conn.prepareStatement("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getLinkedNodeIdOnNodes(Set<Integer> nodeIds, Connection conn) throws SQLException {
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        if (nodeIds == null || nodeIds.size() == 0) {
            return new TreeSet<Integer>();
        }
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            StringBuffer query = new StringBuffer("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID IN (");
            Iterator<Integer> it = nodeIds.iterator();
            StringBuffer nodesStrBuff = new StringBuffer("");
            while (it.hasNext()) {
                nodesStrBuff.append(it.next().toString());
                if (!it.hasNext()) continue;
                nodesStrBuff.append(", ");
            }
            query.append(nodesStrBuff);
            query.append(") AND STATUS != 'D'");
            PreparedStatement stmt = conn.prepareStatement(query.toString());
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt("parentid")));
            }
            query = new StringBuffer("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEID IN (");
            query.append(nodesStrBuff);
            query.append(") AND STATUS != 'D'");
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt("parentid")));
            }
        }
        finally {
            d.cleanUp();
        }
        return new TreeSet<Integer>(nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataLinkInterface[] getDataLinks(int nodeID) throws SQLException {
        DataLinkInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D' ORDER BY IFINDEX");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2DataLink(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataLinkInterface[] getDataLinksFromNodeParent(int nodeID) throws SQLException {
        DataLinkInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D' ORDER BY PARENTIFINDEX");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2DataLink(rs);
        }
        finally {
            d.cleanUp();
        }
        return NetworkElementFactory.invertDataLinkInterface(nodes);
    }

    public static DataLinkInterface[] getDataLinksOnInterface(int nodeID, int ifindex) throws SQLException {
        DataLinkInterface[] normalnodes = null;
        normalnodes = NetworkElementFactory.getDataLinks(nodeID, ifindex);
        DataLinkInterface[] parentnodes = null;
        parentnodes = NetworkElementFactory.getDataLinksFromNodeParent(nodeID, ifindex);
        DataLinkInterface[] nodes = new DataLinkInterface[normalnodes.length + parentnodes.length];
        int j = 0;
        for (DataLinkInterface normalnode : normalnodes) {
            nodes[j++] = normalnode;
        }
        for (DataLinkInterface parentnode : parentnodes) {
            nodes[j++] = parentnode;
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataLinkInterface[] getDataLinks(int nodeID, int ifindex) throws SQLException {
        DataLinkInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D' AND IFINDEX = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2DataLink(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataLinkInterface[] getDataLinksFromNodeParent(int nodeID, int ifindex) throws SQLException {
        DataLinkInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND PARENTIFINDEX = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2DataLink(rs);
        }
        finally {
            d.cleanUp();
        }
        return NetworkElementFactory.invertDataLinkInterface(nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataLinkInterface[] getAllDataLinks() throws SQLException {
        DataLinkInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM DATALINKINTERFACE WHERE STATUS != 'D' ORDER BY NODEID, IFINDEX");
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2DataLink(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vlan[] getVlansOnNode(int nodeID) throws SQLException {
        Vlan[] vlans = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT * from vlan WHERE status != 'D' AND nodeid = ? order by vlanid;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            vlans = NetworkElementFactory.rs2Vlan(rs);
        }
        finally {
            d.cleanUp();
        }
        return vlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StpInterface[] getStpInterface(int nodeID) throws SQLException {
        StpInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT DISTINCT(stpnode.nodeid) AS droot, stpinterfacedb.* FROM ((SELECT DISTINCT(stpnode.nodeid) AS dbridge, stpinterface.* FROM stpinterface LEFT JOIN stpnode ON SUBSTR(stpportdesignatedbridge,5,16) = stpnode.basebridgeaddress AND stpportdesignatedbridge != '0000000000000000'WHERE stpinterface.status != 'D' AND stpinterface.nodeid = ?) AS stpinterfacedb LEFT JOIN stpnode ON SUBSTR(stpportdesignatedroot, 5, 16) = stpnode.basebridgeaddress) order by stpinterfacedb.stpvlan, stpinterfacedb.ifindex;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StpInterface[] getStpInterface(int nodeID, int ifindex) throws SQLException {
        StpInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT DISTINCT(stpnode.nodeid) AS droot, stpinterfacedb.* FROM ((SELECT DISTINCT(stpnode.nodeid) AS dbridge, stpinterface.* FROM stpinterface LEFT JOIN stpnode ON SUBSTR(stpportdesignatedbridge,5,16) = stpnode.basebridgeaddress AND stpportdesignatedbridge != '0000000000000000'WHERE stpinterface.status != 'D' AND stpinterface.nodeid = ? AND stpinterface.ifindex = ?) AS stpinterfacedb LEFT JOIN stpnode ON SUBSTR(stpportdesignatedroot, 5, 16) = stpnode.basebridgeaddress) order by stpinterfacedb.stpvlan, stpinterfacedb.ifindex;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StpNode[] getStpNode(int nodeID) throws SQLException {
        StpNode[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select distinct(e2.nodeid) as stpdesignatedrootnodeid, e1.* from (stpnode e1 left join stpnode e2 on substr(e1.stpdesignatedroot, 5, 16) = e2.basebridgeaddress) where e1.nodeid = ? AND e1.status != 'D' ORDER BY e1.basevlan");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpNode(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    protected static AtInterface[] rs2AtInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<AtInterface> atIfs = new ArrayList<AtInterface>();
        while (rs.next()) {
            AtInterface atIf = new AtInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            atIf.m_nodeId = (Integer)element;
            element = rs.getString("ipaddr");
            atIf.m_ipaddr = (String)element;
            element = rs.getString("atphysaddr");
            atIf.m_physaddr = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                atIf.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("sourcenodeID"))) != null) {
                atIf.m_sourcenodeid = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                atIf.m_ifindex = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                atIf.m_status = ((String)element).charAt(0);
            }
            atIfs.add(atIf);
        }
        return atIfs.toArray(new AtInterface[atIfs.size()]);
    }

    protected static IpRouteInterface[] rs2IpRouteInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<IpRouteInterface> ipRtIfs = new ArrayList<IpRouteInterface>();
        while (rs.next()) {
            IpRouteInterface ipRtIf = new IpRouteInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            ipRtIf.m_nodeId = (Integer)element;
            element = rs.getString("routedest");
            ipRtIf.m_routedest = (String)element;
            element = rs.getString("routemask");
            ipRtIf.m_routemask = (String)element;
            element = rs.getString("routenexthop");
            ipRtIf.m_routenexthop = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                ipRtIf.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("routeifindex"))) != null) {
                ipRtIf.m_routeifindex = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric1"))) != null) {
                ipRtIf.m_routemetric1 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric2"))) != null) {
                ipRtIf.m_routemetric2 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric3"))) != null) {
                ipRtIf.m_routemetric4 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric4"))) != null) {
                ipRtIf.m_routemetric4 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric5"))) != null) {
                ipRtIf.m_routemetric5 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routetype"))) != null) {
                ipRtIf.m_routetype = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routeproto"))) != null) {
                ipRtIf.m_routeproto = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                ipRtIf.m_status = ((String)element).charAt(0);
            }
            ipRtIfs.add(ipRtIf);
        }
        return ipRtIfs.toArray(new IpRouteInterface[ipRtIfs.size()]);
    }

    protected static StpInterface[] rs2StpInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<StpInterface> stpIfs = new ArrayList<StpInterface>();
        while (rs.next()) {
            StpInterface stpIf = new StpInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            stpIf.m_nodeId = (Integer)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                stpIf.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("bridgeport"))) != null) {
                stpIf.m_bridgeport = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                stpIf.m_ifindex = (Integer)element;
            }
            element = rs.getString("stpportdesignatedroot");
            stpIf.m_stpdesignatedroot = (String)element;
            element = new Integer(rs.getInt("stpportdesignatedcost"));
            if (element != null) {
                stpIf.m_stpportdesignatedcost = (Integer)element;
            }
            element = rs.getString("stpportdesignatedbridge");
            stpIf.m_stpdesignatedbridge = (String)element;
            element = rs.getString("stpportdesignatedport");
            stpIf.m_stpdesignatedport = (String)element;
            element = new Integer(rs.getInt("stpportpathcost"));
            if (element != null) {
                stpIf.m_stpportpathcost = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stpportstate"))) != null) {
                stpIf.m_stpportstate = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stpvlan"))) != null) {
                stpIf.m_stpvlan = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                stpIf.m_status = ((String)element).charAt(0);
            }
            if ((element = new Integer(rs.getInt("dbridge"))) != null) {
                stpIf.m_stpbridgenodeid = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("droot"))) != null) {
                stpIf.m_stprootnodeid = (Integer)element;
            }
            stpIf.m_ipaddr = stpIf.get_ifindex() == -1 ? NetworkElementFactory.getIpAddress(stpIf.get_nodeId()) : NetworkElementFactory.getIpAddress(stpIf.get_nodeId(), stpIf.get_ifindex());
            stpIfs.add(stpIf);
        }
        return stpIfs.toArray(new StpInterface[stpIfs.size()]);
    }

    protected static StpNode[] rs2StpNode(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<StpNode> stpNodes = new ArrayList<StpNode>();
        while (rs.next()) {
            StpNode stpNode = new StpNode();
            Object element = new Integer(rs.getInt("nodeId"));
            stpNode.m_nodeId = (Integer)element;
            element = rs.getString("basebridgeaddress");
            stpNode.m_basebridgeaddress = (String)element;
            element = rs.getString("stpdesignatedroot");
            stpNode.m_stpdesignatedroot = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                stpNode.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("basenumports"))) != null) {
                stpNode.m_basenumports = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("basetype"))) != null) {
                stpNode.m_basetype = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("basevlan"))) != null) {
                stpNode.m_basevlan = (Integer)element;
            }
            if ((element = rs.getString("basevlanname")) != null) {
                stpNode.m_basevlanname = (String)element;
            }
            if ((element = new Integer(rs.getInt("stppriority"))) != null) {
                stpNode.m_stppriority = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stpprotocolspecification"))) != null) {
                stpNode.m_stpprotocolspecification = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stprootcost"))) != null) {
                stpNode.m_stprootcost = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stprootport"))) != null) {
                stpNode.m_stprootport = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                stpNode.m_status = ((String)element).charAt(0);
            }
            if ((element = new Integer(rs.getInt("stpdesignatedrootnodeid"))) != null) {
                stpNode.m_stprootnodeid = (Integer)element;
            }
            stpNodes.add(stpNode);
        }
        return stpNodes.toArray(new StpNode[stpNodes.size()]);
    }

    protected static Vlan[] rs2Vlan(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<Vlan> vlan = new ArrayList<Vlan>();
        while (rs.next()) {
            Vlan vlanEntry = new Vlan();
            Object element = new Integer(rs.getInt("nodeId"));
            vlanEntry.m_nodeId = (Integer)element;
            element = rs.getInt("vlanId");
            if (element != null) {
                vlanEntry.m_vlanId = (Integer)element;
            }
            element = rs.getString("vlanname");
            vlanEntry.m_vlanname = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                vlanEntry.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("vlantype"))) != null) {
                vlanEntry.m_vlantype = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("vlanstatus"))) != null) {
                vlanEntry.m_vlanstatus = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                vlanEntry.m_status = ((String)element).charAt(0);
            }
            vlan.add(vlanEntry);
        }
        return vlan.toArray(new Vlan[vlan.size()]);
    }

    protected static DataLinkInterface[] rs2DataLink(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<DataLinkInterface> dataLinkIfs = new ArrayList<DataLinkInterface>();
        while (rs.next()) {
            DataLinkInterface dataLinkIf = new DataLinkInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            dataLinkIf.m_nodeId = (Integer)element;
            element = new Integer(rs.getInt("ifindex"));
            if (element != null) {
                dataLinkIf.m_ifindex = (Integer)element;
            }
            if ((element = rs.getTimestamp("lastpolltime")) != null) {
                dataLinkIf.m_lastPollTime = EventConstants.formatToString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("nodeparentid"))) != null) {
                dataLinkIf.m_nodeparentid = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("parentifindex"))) != null) {
                dataLinkIf.m_parentifindex = (Integer)element;
            }
            if ((element = rs.getString("status")) != null) {
                dataLinkIf.m_status = ((String)element).charAt(0);
            }
            dataLinkIf.m_parentipaddress = NetworkElementFactory.getIpAddress(dataLinkIf.get_nodeparentid(), dataLinkIf.get_parentifindex());
            dataLinkIf.m_ipaddress = dataLinkIf.get_ifindex() == -1 ? NetworkElementFactory.getIpAddress(dataLinkIf.get_nodeId()) : NetworkElementFactory.getIpAddress(dataLinkIf.get_nodeId(), dataLinkIf.get_ifindex());
            dataLinkIfs.add(dataLinkIf);
        }
        return dataLinkIfs.toArray(new DataLinkInterface[dataLinkIfs.size()]);
    }

    protected static DataLinkInterface[] invertDataLinkInterface(DataLinkInterface[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            DataLinkInterface dli = nodes[i];
            dli.invertNodewithParent();
            nodes[i] = dli;
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getIpAddress(int nodeid) throws SQLException {
        String ipaddr = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(IPADDR) FROM IPINTERFACE WHERE NODEID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
            }
        }
        finally {
            d.cleanUp();
        }
        return ipaddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getIpAddress(int nodeid, int ifindex) throws SQLException {
        String ipaddr = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(IPADDR) FROM IPINTERFACE WHERE NODEID = ? AND IFINDEX = ? ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
            }
        }
        finally {
            d.cleanUp();
        }
        return ipaddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getNodeIdsWithIpLike(String iplike) throws SQLException {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<Integer> nodecont = new ArrayList<Integer>();
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(node.nodeid) FROM NODE,IPINTERFACE WHERE NODE.NODEID=IPINTERFACE.NODEID AND IPLIKE(IPINTERFACE.IPADDR,?) AND NODETYPE != 'D'");
            d.watch((Object)stmt);
            stmt.setString(1, iplike);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Integer node = null;
            while (rs.next()) {
                Integer element = new Integer(rs.getInt("nodeid"));
                if (element != null) {
                    node = element;
                }
                nodecont.add(node);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodecont;
    }

    public static Node[] getNodesWithCategories(TransactionTemplate transTemplate, final NodeDao nodeDao, final CategoryDao categoryDao, final String[] categories1, final boolean onlyNodesWithDownAggregateStatus) {
        return (Node[])transTemplate.execute((TransactionCallback)new TransactionCallback<Node[]>(){

            public Node[] doInTransaction(TransactionStatus arg0) {
                return NetworkElementFactory.getNodesWithCategories(nodeDao, categoryDao, categories1, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    public static Node[] getNodesWithCategories(NodeDao nodeDao, CategoryDao categoryDao, String[] categories1, boolean onlyNodesWithDownAggregateStatus) {
        Collection<OnmsNode> ourNodes = NetworkElementFactory.getNodesInCategories(nodeDao, categoryDao, categories1);
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(new HashSet<OnmsNode>(ourNodes));
            ourNodes = as.getDownNodes();
        }
        return NetworkElementFactory.convertOnmsNodeCollectionToNodeArray(ourNodes);
    }

    private static Collection<OnmsNode> getNodesInCategories(NodeDao nodeDao, CategoryDao categoryDao, String[] categoryStrings) {
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>(categoryStrings.length);
        for (String categoryString : categoryStrings) {
            categories.add(categoryDao.findByName(categoryString));
        }
        Collection ourNodes = nodeDao.findAllByCategoryList(categories);
        return ourNodes;
    }

    public static Node[] getNodesWithCategories(TransactionTemplate transTemplate, final NodeDao nodeDao, final CategoryDao categoryDao, final String[] categories1, final String[] categories2, final boolean onlyNodesWithDownAggregateStatus) {
        return (Node[])transTemplate.execute((TransactionCallback)new TransactionCallback<Node[]>(){

            public Node[] doInTransaction(TransactionStatus arg0) {
                return NetworkElementFactory.getNodesWithCategories(nodeDao, categoryDao, categories1, categories2, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    public static Node[] getNodesWithCategories(NodeDao nodeDao, CategoryDao categoryDao, String[] categories1, String[] categories2, boolean onlyNodesWithDownAggregateStatus) {
        ArrayList<OnmsCategory> c1 = new ArrayList<OnmsCategory>(categories1.length);
        for (String category : categories1) {
            c1.add(categoryDao.findByName(category));
        }
        ArrayList<OnmsCategory> c2 = new ArrayList<OnmsCategory>(categories2.length);
        for (String category : categories2) {
            c2.add(categoryDao.findByName(category));
        }
        Collection<OnmsNode> ourNodes1 = NetworkElementFactory.getNodesInCategories(nodeDao, categoryDao, categories1);
        Collection<OnmsNode> ourNodes2 = NetworkElementFactory.getNodesInCategories(nodeDao, categoryDao, categories2);
        HashSet<Integer> n2id = new HashSet<Integer>(ourNodes2.size());
        for (OnmsNode n2 : ourNodes2) {
            n2id.add(n2.getId());
        }
        Set<OnmsNode> ourNodes = new HashSet<OnmsNode>();
        for (OnmsNode n1 : ourNodes1) {
            if (!n2id.contains(n1.getId())) continue;
            ourNodes.add(n1);
        }
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(ourNodes);
            ourNodes = as.getDownNodes();
        }
        return NetworkElementFactory.convertOnmsNodeCollectionToNodeArray(ourNodes);
    }

    public static Node[] convertOnmsNodeCollectionToNodeArray(Collection<OnmsNode> ourNodes) {
        ArrayList<Node> theirNodes = new ArrayList<Node>(ourNodes.size());
        for (OnmsNode on : ourNodes) {
            theirNodes.add(new Node(on.getId(), 0, on.getLabel(), null, on.getCreateTime().toString(), null, on.getSysName(), on.getSysDescription(), on.getSysLocation(), on.getSysContact(), on.getType().charAt(0), on.getOperatingSystem(), on.getForeignId(), on.getForeignSource()));
        }
        return theirNodes.toArray(new Node[0]);
    }

    static {
        INTERFACE_COMPARATOR = new InterfaceComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InterfaceComparator
    implements Comparator<Interface> {
        @Override
        public int compare(Interface o1, Interface o2) {
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                if (IPSorter.convertToLong((String)o1.getIpAddress()) > IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return 1;
                }
                if (IPSorter.convertToLong((String)o1.getIpAddress()) < IPSorter.convertToLong((String)o2.getIpAddress())) {
                    return -1;
                }
                return 0;
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            return 0;
        }
    }
}

