/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.opennms.web.MissingParameterException;
import org.opennms.web.element.ElementIdNotFoundException;
import org.opennms.web.element.ElementNotFoundException;
import org.opennms.web.element.Interface;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Node;
import org.opennms.web.element.Service;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    private static Map<Character, String> m_nodeStatusMap;
    private static Map<Character, String> m_interfaceStatusMap;
    private static Map<Character, String> m_interfaceSnmpStatusMap;
    private static Map<Character, String> m_serviceStatusMap;
    public static final int DEFAULT_TRUNCATE_THRESHOLD = 28;

    protected static Map<Character, String> getNodeStatusMap() {
        if (m_nodeStatusMap == null) {
            ElementUtil.initNodeStatusMap();
        }
        return m_nodeStatusMap;
    }

    private static synchronized void initNodeStatusMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(new Character('A'), "Active");
        map.put(new Character(' '), "Unknown");
        map.put(new Character('D'), "Deleted");
        m_nodeStatusMap = map;
    }

    public static String getNodeStatusString(Node node) {
        Assert.notNull((Object)node, (String)"node argument cannot be null");
        return ElementUtil.getNodeStatusString(node.getNodeType());
    }

    public static String getNodeStatusString(char c) {
        return ElementUtil.getNodeStatusMap().get(new Character(c));
    }

    protected static Map<Character, String> getInterfaceStatusMap() {
        if (m_interfaceStatusMap == null) {
            ElementUtil.initInterfaceStatusMap();
        }
        return m_interfaceStatusMap;
    }

    private static synchronized void initInterfaceStatusMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(new Character('M'), "Managed");
        map.put(new Character('U'), "Unmanaged");
        map.put(new Character('D'), "Deleted");
        map.put(new Character('F'), "Forced Unmanaged");
        map.put(new Character('N'), "Not Monitored");
        m_interfaceStatusMap = map;
    }

    protected static Map<Character, String> getSnmpInterfaceStatusMap() {
        if (m_interfaceSnmpStatusMap == null) {
            ElementUtil.initSnmpInterfaceStatusMap();
        }
        return m_interfaceSnmpStatusMap;
    }

    private static synchronized void initSnmpInterfaceStatusMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(new Character('P'), "Polled");
        map.put(new Character('N'), "Not Monitored");
        m_interfaceSnmpStatusMap = map;
    }

    public static String getInterfaceStatusString(Interface intf) {
        Assert.notNull((Object)intf, (String)"intf argument cannot be null");
        return ElementUtil.getInterfaceStatusString(intf.isManagedChar());
    }

    public static String getInterfaceStatusString(char c) {
        Map<Character, String> statusMap = ElementUtil.getInterfaceStatusMap();
        return statusMap.get(new Character(c));
    }

    public static String getSnmpInterfaceStatusString(Interface intf) {
        Assert.notNull((Object)intf, (String)"intf argument cannot be null");
        return ElementUtil.getSnmpInterfaceStatusString(intf.isSnmpPollChar());
    }

    public static String getSnmpInterfaceStatusString(char c) {
        Map<Character, String> statusMap = ElementUtil.getSnmpInterfaceStatusMap();
        return statusMap.get(new Character(c));
    }

    protected static Map<Character, String> getServiceStatusMap() {
        if (m_serviceStatusMap == null) {
            ElementUtil.initServiceStatusMap();
        }
        return m_serviceStatusMap;
    }

    private static synchronized void initServiceStatusMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(new Character('A'), "Managed");
        map.put(new Character('U'), "Unmanaged");
        map.put(new Character('D'), "Deleted");
        map.put(new Character('F'), "Forced Unmanaged");
        map.put(new Character('N'), "Not Monitored");
        map.put(new Character('R'), "Rescan to Resume");
        map.put(new Character('S'), "Rescan to Suspend");
        map.put(new Character('X'), "Remotely Monitored");
        m_serviceStatusMap = map;
    }

    public static String getServiceStatusString(Service svc) {
        Assert.notNull((Object)svc, (String)"svc argument cannot be null");
        return ElementUtil.getServiceStatusString(svc.getStatus());
    }

    public static String getServiceStatusString(char c) {
        Map<Character, String> statusMap = ElementUtil.getServiceStatusMap();
        return statusMap.get(new Character(c));
    }

    public static boolean hasLocallyMonitoredServices(Service[] svcs) {
        for (Service svc : svcs) {
            char status = svc.getStatus();
            if (status == 'X') continue;
            return true;
        }
        return false;
    }

    public static String truncateLabel(String label) {
        return ElementUtil.truncateLabel(label, 28);
    }

    public static String truncateLabel(String label, int truncateThreshold) {
        Assert.notNull((Object)label, (String)"label argument cannot be null");
        Assert.isTrue((truncateThreshold >= 3 ? 1 : 0) != 0, (String)("Cannot take a truncate position less than 3 (truncateThreshold is " + truncateThreshold + ")"));
        String shortLabel = label;
        if (label.length() > truncateThreshold) {
            shortLabel = label.substring(0, truncateThreshold - 3) + "...";
        }
        return shortLabel;
    }

    public static Node getNodeByParams(HttpServletRequest request) throws ServletException, SQLException {
        return ElementUtil.getNodeByParams(request, "node");
    }

    public static Node getNodeByParams(HttpServletRequest request, String nodeIdParam) throws ServletException, SQLException {
        int nodeId;
        if (request.getParameter(nodeIdParam) == null) {
            throw new MissingParameterException(nodeIdParam, new String[]{"node"});
        }
        String nodeIdString = request.getParameter(nodeIdParam);
        try {
            nodeId = Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException e) {
            throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node", "element/node.jsp", "node", "element/nodeList.htm");
        }
        Node node = NetworkElementFactory.getNode(nodeId);
        if (node == null) {
            throw new ElementNotFoundException("No such node in database", "node", "element/node.jsp", "node", "element/nodeList.htm");
        }
        return node;
    }

    public static Interface getInterfaceByParams(HttpServletRequest request) throws ServletException, SQLException {
        return ElementUtil.getInterfaceByParams(request, "ipinterfaceid", "node", "intf", "ifindex");
    }

    public static Interface getInterfaceByParams(HttpServletRequest request, String ipInterfaceIdParam, String nodeIdParam, String ipAddrParam, String ifIndexParam) throws ServletException, SQLException {
        Interface intf;
        if (request.getParameter(ipInterfaceIdParam) != null) {
            int ipInterfaceId;
            String ifServiceIdString = request.getParameter(ipInterfaceIdParam);
            try {
                ipInterfaceId = Integer.parseInt(ifServiceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + ipInterfaceIdParam + "\", should be integer", ifServiceIdString, "service");
            }
            intf = NetworkElementFactory.getInterface(ipInterfaceId);
        } else {
            int nodeId;
            String nodeIdString = request.getParameter(nodeIdParam);
            String ipAddr = request.getParameter(ipAddrParam);
            String ifIndexString = request.getParameter(ifIndexParam);
            int ifIndex = -1;
            String[] requiredParameters = new String[]{nodeIdParam, ipAddrParam};
            if (nodeIdString == null) {
                throw new MissingParameterException(nodeIdParam, requiredParameters);
            }
            if (ipAddr == null) {
                throw new MissingParameterException(ipAddrParam, requiredParameters);
            }
            try {
                nodeId = Integer.parseInt(nodeIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
            }
            if (ifIndexString != null) {
                try {
                    ifIndex = Integer.parseInt(ifIndexString);
                }
                catch (NumberFormatException e) {
                    throw new ElementIdNotFoundException("Wrong data type for \"" + ifIndexParam + "\", should be integer", ifIndexString, "interface");
                }
            }
            intf = ifIndex != -1 ? NetworkElementFactory.getInterface(nodeId, ipAddr, ifIndex) : NetworkElementFactory.getInterface(nodeId, ipAddr);
        }
        if (intf == null) {
            throw new ElementNotFoundException("No such interface in database", "interface", "element/interface.jsp", "ipinterfaceid", "element/interface.jsp");
        }
        return intf;
    }

    public static Interface getSnmpInterfaceByParams(HttpServletRequest request) throws ServletException, SQLException {
        return ElementUtil.getSnmpInterfaceByParams(request, "node", "ifindex");
    }

    public static Interface getSnmpInterfaceByParams(HttpServletRequest request, String nodeIdParam, String ifIndexParam) throws ServletException, SQLException {
        int ifIndex;
        int nodeId;
        String nodeIdString = request.getParameter(nodeIdParam);
        String ifIndexString = request.getParameter(ifIndexParam);
        String[] requiredParameters = new String[]{nodeIdParam, ifIndexParam};
        if (nodeIdString == null) {
            throw new MissingParameterException(nodeIdParam, requiredParameters);
        }
        if (ifIndexString == null) {
            throw new MissingParameterException(ifIndexParam, requiredParameters);
        }
        try {
            nodeId = Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException e) {
            throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
        }
        try {
            ifIndex = Integer.parseInt(ifIndexString);
        }
        catch (NumberFormatException e) {
            throw new ElementIdNotFoundException("Wrong data type for \"" + ifIndexParam + "\", should be integer", ifIndexString, "interface");
        }
        Interface intf = NetworkElementFactory.getSnmpInterface(nodeId, ifIndex);
        if (intf == null) {
            throw new ElementNotFoundException("No such snmp interface in database for nodeId " + nodeIdString + " ifIndex " + ifIndexString, "snmpinterface");
        }
        return intf;
    }

    public static Service getServiceByParams(HttpServletRequest request) throws ServletException, SQLException {
        return ElementUtil.getServiceByParams(request, "ifserviceid", "node", "intf", "service");
    }

    public static Service getServiceByParams(HttpServletRequest request, String ifServiceIdParam, String nodeIdParam, String ipAddrParam, String serviceIdParam) throws ServletException, SQLException {
        Service service;
        if (request.getParameter(ifServiceIdParam) != null) {
            int ifServiceId;
            String ifServiceIdString = request.getParameter(ifServiceIdParam);
            try {
                ifServiceId = Integer.parseInt(ifServiceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + ifServiceIdParam + "\", should be integer", ifServiceIdString, "service");
            }
            service = NetworkElementFactory.getService(ifServiceId);
        } else {
            int serviceId;
            int nodeId;
            String nodeIdString = request.getParameter(nodeIdParam);
            String ipAddr = request.getParameter(ipAddrParam);
            String serviceIdString = request.getParameter(serviceIdParam);
            String[] requiredParameters = new String[]{nodeIdParam, ipAddrParam, serviceIdParam};
            if (nodeIdString == null) {
                throw new MissingParameterException(nodeIdParam, requiredParameters);
            }
            if (ipAddr == null) {
                throw new MissingParameterException(ipAddrParam, requiredParameters);
            }
            if (serviceIdString == null) {
                throw new MissingParameterException(serviceIdParam, requiredParameters);
            }
            try {
                nodeId = Integer.parseInt(nodeIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
            }
            try {
                serviceId = Integer.parseInt(serviceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + serviceIdParam + "\", should be integer", serviceIdString, "service");
            }
            service = NetworkElementFactory.getService(nodeId, ipAddr, serviceId);
        }
        if (service == null) {
            String ipAddr = request.getParameter(ipAddrParam);
            String serviceIdString = request.getParameter(serviceIdParam);
            throw new ElementNotFoundException("No such service in database for " + ipAddr + " with service ID " + serviceIdString, "service");
        }
        return service;
    }

    public static Service[] getServicesOnNodeByParams(HttpServletRequest request, int serviceId) throws SQLException {
        int nodeId;
        try {
            nodeId = Integer.parseInt(request.getParameter("node"));
        }
        catch (NumberFormatException nfe) {
            throw new ElementIdNotFoundException("Wrong type for parameter \"node\" (should be integer)", request.getParameter("node"), "node", "element/node.jsp", "node", "element/nodeList.jsp");
        }
        Service[] services = NetworkElementFactory.getServicesOnNode(nodeId, serviceId);
        return services;
    }

    public static boolean isRouteInfoNodeByParams(HttpServletRequest request) throws SQLException {
        int nodeId;
        try {
            nodeId = Integer.parseInt(request.getParameter("node"));
        }
        catch (NumberFormatException nfe) {
            throw new ElementIdNotFoundException("Wrong type for parameter \"node\" (should be integer)", request.getParameter("node"), "node", "element/node.jsp", "node", "element/nodeList.jsp");
        }
        return NetworkElementFactory.isRouteInfoNode(nodeId);
    }

    private static String encodeUrl(String in) {
        String out = "";
        try {
            out = URLEncoder.encode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return out;
    }

    private ElementUtil() {
    }
}

