/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.statisticsReports;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.command.StatisticsReportCommand;
import org.opennms.web.controller.statisticsReports.StatisticsReportIdNotFoundException;
import org.opennms.web.svclayer.StatisticsReportService;
import org.opennms.web.svclayer.support.StatisticsReportModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

public class ReportController
extends AbstractCommandController
implements InitializingBean {
    private StatisticsReportService m_statisticsReportService;
    private String m_successView;

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object cmd, BindException errors) throws Exception {
        StatisticsReportCommand command = (StatisticsReportCommand)cmd;
        try {
            StatisticsReportModel report = this.m_statisticsReportService.getReport(command, errors);
            return new ModelAndView(this.getSuccessView(), "model", (Object)report);
        }
        catch (HibernateObjectRetrievalFailureException horfe) {
            throw new StatisticsReportIdNotFoundException("No such report ID", command.getId().toString());
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_statisticsReportService != null ? 1 : 0) != 0, (String)"property statisticsReportService must be set to a non-null value");
        Assert.state((this.m_successView != null ? 1 : 0) != 0, (String)"property successView must be set to a non-null value");
    }

    public StatisticsReportService getStatisticsReportService() {
        return this.m_statisticsReportService;
    }

    public void setStatisticsReportService(StatisticsReportService statisticsReportService) {
        this.m_statisticsReportService = statisticsReportService;
    }

    public String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }
}

