/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.outage;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageQueryParms;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.OutageUtil;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class OutageFilterController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_MULTIPLE = 0;
    private String m_successView;
    private Integer m_defaultShortLimit;
    private Integer m_defaultLongLimit;
    private OutageType m_defaultOutageType = OutageType.CURRENT;
    private SortStyle m_defaultSortStyle = SortStyle.ID;
    private WebOutageRepository m_webOutageRepository;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SortStyle temp;
        String display = request.getParameter("display");
        String sortStyleString = request.getParameter("sortby");
        SortStyle sortStyle = this.m_defaultSortStyle;
        if (sortStyleString != null && (temp = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp;
        }
        String outageTypeString = request.getParameter("outtype");
        OutageType outageType = this.m_defaultOutageType;
        if (outageTypeString != null) {
            OutageType temp2 = OutageType.getOutageType(outageTypeString);
            if (temp2 != null) {
                outageType = temp2;
            } else {
                try {
                    int outageTypeInt = Integer.parseInt(outageTypeString);
                    outageType = OutageType.values()[outageTypeInt - 1];
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        String[] filterStrings = request.getParameterValues("filter");
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (String filterString : filterStrings) {
                Filter filter = OutageUtil.getFilter(filterString);
                if (filter == null) continue;
                filterList.add(filter);
            }
        }
        String limitString = request.getParameter("limit");
        int limit = "long".equals(display) ? this.getDefaultLongLimit() : this.getDefaultShortLimit();
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Filter[] filters = filterList.toArray(new Filter[0]);
        OutageQueryParms parms = new OutageQueryParms();
        parms.outageType = outageType;
        parms.filters = filterList;
        parms.limit = limit;
        parms.multiple = multiple;
        parms.sortStyle = sortStyle;
        OutageCriteria queryCriteria = new OutageCriteria(filters, sortStyle, outageType, limit, limit * multiple);
        OutageCriteria countCriteria = new OutageCriteria(outageType, filters);
        Outage[] outages = this.m_webOutageRepository.getMatchingOutages(queryCriteria);
        int outageCount = this.m_webOutageRepository.countMatchingOutages(countCriteria);
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("outages", (Object)outages);
        modelAndView.addObject("outageCount", (Object)outageCount);
        modelAndView.addObject("parms", (Object)parms);
        return modelAndView;
    }

    private Integer getDefaultShortLimit() {
        return this.m_defaultShortLimit;
    }

    public void setDefaultShortLimit(Integer limit) {
        this.m_defaultShortLimit = limit;
    }

    private Integer getDefaultLongLimit() {
        return this.m_defaultLongLimit;
    }

    public void setDefaultLongLimit(Integer limit) {
        this.m_defaultLongLimit = limit;
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebOutageRepository(WebOutageRepository webOutageRepository) {
        this.m_webOutageRepository = webOutageRepository;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultShortLimit, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultShortLimit > 0 ? 1 : 0) != 0, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_defaultLongLimit, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultLongLimit > 0 ? 1 : 0) != 0, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webOutageRepository, (String)"webOutageRepository must be set");
    }

    public OutageType getDefaultOutageType() {
        return this.m_defaultOutageType;
    }

    public void setDefaultOutageType(OutageType defaultOutageType) {
        this.m_defaultOutageType = defaultOutageType;
    }

    public SortStyle getDefaultSortStyle() {
        return this.m_defaultSortStyle;
    }

    public void setDefaultSortStyle(SortStyle defaultSortStyle) {
        this.m_defaultSortStyle = defaultSortStyle;
    }
}

