/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.KscReportEditor;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.svclayer.KscReportService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcReportController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        KscReportEditor editor = KscReportEditor.getFromSession((HttpSession)request.getSession(), (boolean)true);
        Report report = editor.getWorkingReport();
        String action = WebSecurityUtils.sanitizeString((String)request.getParameter("action"));
        String report_title = WebSecurityUtils.sanitizeString((String)request.getParameter("report_title"));
        String show_timespan = WebSecurityUtils.sanitizeString((String)request.getParameter("show_timespan"));
        String show_graphtype = WebSecurityUtils.sanitizeString((String)request.getParameter("show_graphtype"));
        String g_index = WebSecurityUtils.sanitizeString((String)request.getParameter("graph_index"));
        int graph_index = WebSecurityUtils.safeParseInt((String)g_index);
        int graphs_per_line = WebSecurityUtils.safeParseInt((String)request.getParameter("graphs_per_line"));
        report.setTitle(report_title);
        if (show_graphtype == null) {
            report.setShow_graphtype_button(false);
        } else {
            report.setShow_graphtype_button(true);
        }
        if (show_timespan == null) {
            report.setShow_timespan_button(false);
        } else {
            report.setShow_timespan_button(true);
        }
        if (graphs_per_line > 0) {
            report.setGraphs_per_line(graphs_per_line);
        } else {
            report.setGraphs_per_line(0);
        }
        if (action.equals("Save")) {
            try {
                editor.unloadWorkingReport(this.getKscReportFactory());
                this.getKscReportFactory().saveCurrent();
            }
            catch (Exception e) {
                throw new ServletException("Couldn't save KSC_PerformanceReportFactory.", (Throwable)e);
            }
        } else if (action.equals("AddGraph") || action.equals("ModGraph")) {
            editor.loadWorkingGraph(graph_index);
        } else if (action.equals("DelGraph")) {
            report.removeGraph(report.getGraph(graph_index));
        } else {
            throw new ServletException("Invalid Argument for Customize Form Action.");
        }
        if (action.equals("Save")) {
            return new ModelAndView("redirect:/KSC/index.htm");
        }
        if (action.equals("DelGraph")) {
            return new ModelAndView("redirect:/KSC/customReport.htm");
        }
        if (action.equals("AddGraph")) {
            return new ModelAndView("redirect:/KSC/customGraphChooseParentResource.htm");
        }
        if (action.equals("ModGraph")) {
            Graph graph = editor.getWorkingGraph();
            OnmsResource resource = this.getKscReportService().getResourceFromGraph(graph);
            return new ModelAndView("redirect:/KSC/customGraphEditDetails.htm", "resourceId", (Object)resource.getId());
        }
        throw new IllegalArgumentException("parameter action of '" + action + "' is not supported.  Must be one of: Save, Cancel, Update, AddGraph, or DelGraph");
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }
}

