/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.KscReportEditor;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcMainController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action = WebSecurityUtils.sanitizeString((String)request.getParameter("report_action"));
        if (action == null) {
            throw new MissingParameterException("report_action");
        }
        KscReportEditor editor = KscReportEditor.getFromSession((HttpSession)request.getSession(), (boolean)false);
        if (action.equals("View")) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customView.htm");
            modelAndView.addObject("report", (Object)this.getReportIndex(request));
            modelAndView.addObject("type", (Object)"custom");
            return modelAndView;
        }
        if (!request.isUserInRole("ROLE_READONLY") && request.getRemoteUser() != null) {
            if (action.equals("Customize")) {
                editor.loadWorkingReport(this.getKscReportFactory(), this.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
            if (action.equals("CreateFrom")) {
                editor.loadWorkingReportDuplicate(this.getKscReportFactory(), this.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
            if (action.equals("Delete")) {
                this.getKscReportFactory().deleteReportAndSave(this.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/index.htm");
            }
            if (action.equals("Create")) {
                editor.loadNewWorkingReport();
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
        }
        throw new ServletException("Invalid Parameter contents for report_action: " + action);
    }

    private int getReportIndex(HttpServletRequest request) {
        String report = WebSecurityUtils.sanitizeString((String)request.getParameter("report"));
        if (report == null) {
            throw new MissingParameterException("report");
        }
        return WebSecurityUtils.safeParseInt((String)report);
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
    }
}

