/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.MissingParameterException;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomGraphChooseResourceController
extends AbstractController
implements InitializingBean {
    private ResourceService m_resourceService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("KSC/customGraphChooseResource");
        String resourceId = request.getParameter("resourceId");
        if (resourceId == null) {
            throw new MissingParameterException("resourceId");
        }
        String selectedResourceId = request.getParameter("selectedResourceId");
        if (selectedResourceId != null) {
            try {
                OnmsResource selectedResource = this.m_resourceService.getResourceById(selectedResourceId);
                HashMap<String, OnmsResource> selectedResourceAndParents = new HashMap<String, OnmsResource>();
                for (OnmsResource r = selectedResource; r != null; r = r.getParent()) {
                    selectedResourceAndParents.put(r.getId(), r);
                }
                modelAndView.addObject("selectedResourceAndParents", selectedResourceAndParents);
            }
            catch (DataAccessException e) {
                // empty catch block
            }
        }
        OnmsResource resource = this.getResourceService().loadResourceById(resourceId);
        modelAndView.addObject("parentResource", (Object)resource);
        modelAndView.addObject("parentResourcePrefabGraphs", (Object)this.m_resourceService.findPrefabGraphsForResource(resource));
        List<OnmsResource> childResources = this.getResourceService().findChildResources(resource, new String[0]);
        modelAndView.addObject("resources", childResources);
        return modelAndView;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
    }
}

