/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.event;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.EventQueryParms;
import org.opennms.web.event.EventUtil;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class EventFilterController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_MULTIPLE = 0;
    private String m_successView;
    private Integer m_defaultShortLimit;
    private Integer m_defaultLongLimit;
    private AcknowledgeType m_defaultEventType = AcknowledgeType.UNACKNOWLEDGED;
    private SortStyle m_defaultSortStyle = SortStyle.ID;
    private WebEventRepository m_webEventRepository;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String idString;
        SortStyle temp;
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        AcknowledgeType ackType = this.m_defaultEventType;
        String display = request.getParameter("display");
        String limitString = request.getParameter("limit");
        int limit = "long".equals(display) ? this.getDefaultLongLimit() : this.getDefaultShortLimit();
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String sortStyleString = request.getParameter("sortby");
        SortStyle sortStyle = this.m_defaultSortStyle;
        if (sortStyleString != null && (temp = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp;
        }
        if ((idString = request.getParameter("id")) != null) {
            filterList.add(new EventIdFilter(WebSecurityUtils.safeParseInt((String)idString)));
            ackType = null;
        } else {
            String[] filterStrings;
            AcknowledgeType temp2;
            String ackTypeString = request.getParameter("acktype");
            if (ackTypeString != null && (temp2 = AcknowledgeType.getAcknowledgeType(ackTypeString)) != null) {
                ackType = temp2;
            }
            if ((filterStrings = request.getParameterValues("filter")) != null) {
                for (String filterString : filterStrings) {
                    Filter filter = EventUtil.getFilter(filterString);
                    if (filter == null) continue;
                    filterList.add(filter);
                }
            }
        }
        Filter[] filters = filterList.toArray(new Filter[0]);
        EventQueryParms parms = new EventQueryParms();
        parms.ackType = ackType;
        parms.display = display;
        parms.filters = filterList;
        parms.limit = limit;
        parms.multiple = multiple;
        parms.sortStyle = sortStyle;
        EventCriteria queryCriteria = new EventCriteria(filters, sortStyle, ackType, limit, limit * multiple);
        Event[] events = this.m_webEventRepository.getMatchingEvents(queryCriteria);
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("events", (Object)events);
        modelAndView.addObject("parms", (Object)parms);
        return modelAndView;
    }

    private Integer getDefaultShortLimit() {
        return this.m_defaultShortLimit;
    }

    public void setDefaultShortLimit(Integer limit) {
        this.m_defaultShortLimit = limit;
    }

    private Integer getDefaultLongLimit() {
        return this.m_defaultLongLimit;
    }

    public void setDefaultLongLimit(Integer limit) {
        this.m_defaultLongLimit = limit;
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebEventRepository(WebEventRepository webEventRepository) {
        this.m_webEventRepository = webEventRepository;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultShortLimit, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultShortLimit > 0 ? 1 : 0) != 0, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_defaultLongLimit, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultLongLimit > 0 ? 1 : 0) != 0, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webEventRepository, (String)"webEventRepository must be set");
    }

    public AcknowledgeType getDefaultAcknowledgeType() {
        return this.m_defaultEventType;
    }

    public void setDefaultAcknowledgeType(AcknowledgeType defaultAcknowledgeType) {
        this.m_defaultEventType = defaultAcknowledgeType;
    }

    public SortStyle getDefaultSortStyle() {
        return this.m_defaultSortStyle;
    }

    public void setDefaultSortStyle(SortStyle defaultSortStyle) {
        this.m_defaultSortStyle = defaultSortStyle;
    }
}

