/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.AlarmQueryParms;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AlarmFilterController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_MULTIPLE = 0;
    private String m_successView;
    private Integer m_defaultShortLimit;
    private Integer m_defaultLongLimit;
    private AcknowledgeType m_defaultAcknowledgeType = AcknowledgeType.UNACKNOWLEDGED;
    private SortStyle m_defaultSortStyle = SortStyle.ID;
    private WebAlarmRepository m_webAlarmRepository;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcknowledgeType temp;
        SortStyle temp2;
        String display = request.getParameter("display");
        String sortStyleString = request.getParameter("sortby");
        SortStyle sortStyle = this.m_defaultSortStyle;
        if (sortStyleString != null && (temp2 = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp2;
        }
        String ackTypeString = request.getParameter("acktype");
        AcknowledgeType ackType = this.m_defaultAcknowledgeType;
        if (ackTypeString != null && (temp = AcknowledgeType.getAcknowledgeType(ackTypeString)) != null) {
            ackType = temp;
        }
        String[] filterStrings = request.getParameterValues("filter");
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (int i = 0; i < filterStrings.length; ++i) {
                Filter filter = AlarmUtil.getFilter(filterStrings[i]);
                if (filter == null) continue;
                filterList.add(filter);
            }
        }
        String limitString = request.getParameter("limit");
        int limit = "long".equals(display) ? this.getDefaultLongLimit() : this.getDefaultShortLimit();
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Filter[] filters = filterList.toArray(new Filter[0]);
        AlarmQueryParms parms = new AlarmQueryParms();
        parms.ackType = ackType;
        parms.display = display;
        parms.filters = filterList;
        parms.limit = limit;
        parms.multiple = multiple;
        parms.sortStyle = sortStyle;
        AlarmCriteria queryCriteria = new AlarmCriteria(filters, sortStyle, ackType, limit, limit * multiple);
        AlarmCriteria countCriteria = new AlarmCriteria(ackType, filters);
        Alarm[] alarms = this.m_webAlarmRepository.getMatchingAlarms(queryCriteria);
        int alarmCount = this.m_webAlarmRepository.countMatchingAlarms(countCriteria);
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("alarms", (Object)alarms);
        modelAndView.addObject("alarmCount", (Object)alarmCount);
        modelAndView.addObject("parms", (Object)parms);
        return modelAndView;
    }

    private Integer getDefaultShortLimit() {
        return this.m_defaultShortLimit;
    }

    public void setDefaultShortLimit(Integer limit) {
        this.m_defaultShortLimit = limit;
    }

    private Integer getDefaultLongLimit() {
        return this.m_defaultLongLimit;
    }

    public void setDefaultLongLimit(Integer limit) {
        this.m_defaultLongLimit = limit;
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebAlarmRepository(WebAlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultShortLimit, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultShortLimit > 0 ? 1 : 0) != 0, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_defaultLongLimit, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultLongLimit > 0 ? 1 : 0) != 0, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }

    public AcknowledgeType getDefaultAcknowledgeType() {
        return this.m_defaultAcknowledgeType;
    }

    public void setDefaultAcknowledgeType(AcknowledgeType defaultAcknowledgeType) {
        this.m_defaultAcknowledgeType = defaultAcknowledgeType;
    }

    public SortStyle getDefaultSortStyle() {
        return this.m_defaultSortStyle;
    }

    public void setDefaultSortStyle(SortStyle defaultSortStyle) {
        this.m_defaultSortStyle = defaultSortStyle;
    }
}

