/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.StreamUtils;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.svclayer.RrdGraphService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RrdGraphController
extends AbstractController {
    private RrdGraphService m_rrdGraphService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream tempIn;
        long endTime;
        long startTime;
        String[] requiredParameters;
        for (String requiredParameter : requiredParameters = new String[]{"resourceId", "start", "end"}) {
            if (request.getParameter(requiredParameter) != null) continue;
            throw new MissingParameterException(requiredParameter, requiredParameters);
        }
        String resourceId = request.getParameter("resourceId");
        String start = request.getParameter("start");
        String end = request.getParameter("end");
        try {
            startTime = WebSecurityUtils.safeParseLong((String)start);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse start '" + start + "' as an integer time: " + e.getMessage(), e);
        }
        try {
            endTime = WebSecurityUtils.safeParseLong((String)end);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse end '" + end + "' as an integer time: " + e.getMessage(), e);
        }
        if ("true".equals(request.getParameter("adhoc"))) {
            String[] adhocRequiredParameters;
            for (String requiredParameter : adhocRequiredParameters = new String[]{"title", "ds", "agfunction", "color", "dstitle", "style"}) {
                if (request.getParameter(requiredParameter) != null) continue;
                throw new MissingParameterException(requiredParameter, adhocRequiredParameters);
            }
            String title = request.getParameter("title");
            String[] dataSources = request.getParameterValues("ds");
            String[] aggregateFunctions = request.getParameterValues("agfunction");
            String[] colors = request.getParameterValues("color");
            String[] dataSourceTitles = request.getParameterValues("dstitle");
            String[] styles = request.getParameterValues("style");
            tempIn = this.m_rrdGraphService.getAdhocGraph(resourceId, title, dataSources, aggregateFunctions, colors, dataSourceTitles, styles, startTime, endTime);
        } else {
            String report = request.getParameter("report");
            if (report == null) {
                throw new MissingParameterException("report");
            }
            tempIn = this.m_rrdGraphService.getPrefabGraph(resourceId, report, startTime, endTime);
        }
        response.setContentType("image/png");
        StreamUtils.streamToStream((InputStream)tempIn, (OutputStream)response.getOutputStream());
        tempIn.close();
        return null;
    }

    public RrdGraphService getRrdGraphService() {
        return this.m_rrdGraphService;
    }

    public void setRrdGraphService(RrdGraphService rrdGraphService) {
        this.m_rrdGraphService = rrdGraphService;
    }
}

