/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.beans.PropertyEditor;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.opennms.web.svclayer.CategoryConfigService;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineReportController
extends SimpleFormController {
    private ReportWrapperService m_reportWrapperService;
    private CategoryConfigService m_catConfigService;

    public OnlineReportController() {
        this.setFormView("report/database/onlineReport");
    }

    protected Object formBackingObject(HttpServletRequest req) throws Exception {
        return this.m_reportWrapperService.getParameters(req.getParameter("reportId"));
    }

    protected Map<String, Object> referenceData(HttpServletRequest req) throws Exception {
        String reportId = req.getParameter("reportId");
        HashMap<String, Object> data = new HashMap<String, Object>();
        List formats = this.m_reportWrapperService.getFormats(reportId);
        data.put("formats", formats);
        List<String> categories = this.m_catConfigService.getCategoriesList();
        data.put("categories", categories);
        return data;
    }

    protected void initBinder(HttpServletRequest req, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ReportParameters parameters = (ReportParameters)command;
        if (parameters.getFormat() == ReportFormat.PDF || parameters.getFormat() == ReportFormat.SVG) {
            response.setContentType("application/pdf;charset=UTF-8");
            response.setHeader("Content-disposition", "inline; filename=report.pdf");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "cache");
            response.setHeader("Cache-Control", "must-revalidate");
        }
        this.m_reportWrapperService.runAndRender(parameters, (OutputStream)response.getOutputStream());
        return null;
    }

    public void setReportWrapperService(ReportWrapperService reportWrapperService) {
        this.m_reportWrapperService = reportWrapperService;
    }

    public void setCategoryConfigService(CategoryConfigService catConfigService) {
        this.m_catConfigService = catConfigService;
    }
}

