/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.web.command.ManageDatabaseReportCommand;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDatabaseReportController
extends SimpleFormController {
    private int m_pageSize;
    private ReportStoreService m_reportStoreService;

    public ManageDatabaseReportController() {
        this.setFormView("report/database/manage");
    }

    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }

    public void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    protected Map<String, Object> referenceData(HttpServletRequest req) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List reportCatalog = this.m_reportStoreService.getAll();
        Map formatMap = this.m_reportStoreService.getFormatMap();
        PagedListHolder pagedListHolder = new PagedListHolder(reportCatalog);
        pagedListHolder.setPageSize(this.m_pageSize);
        int page = ServletRequestUtils.getIntParameter((ServletRequest)req, (String)"p", (int)0);
        pagedListHolder.setPage(page);
        data.put("formatMap", formatMap);
        data.put("pagedListHolder", pagedListHolder);
        return data;
    }

    protected ModelAndView onSubmit(Object command) throws Exception {
        ManageDatabaseReportCommand manageCommand = (ManageDatabaseReportCommand)command;
        this.m_reportStoreService.delete(manageCommand.getIds());
        ModelAndView mav = new ModelAndView(this.getSuccessView());
        return mav;
    }
}

