/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.web.svclayer.AdminCategoryService;
import org.opennms.web.svclayer.support.DefaultAdminCategoryService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class CategoryController
extends AbstractController {
    private AdminCategoryService m_adminCategoryService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String removeCategoryIdString = request.getParameter("removeCategoryId");
        String newCategoryName = request.getParameter("newCategoryName");
        String categoryIdString = request.getParameter("categoryid");
        String editString = request.getParameter("edit");
        String nodeIdString = request.getParameter("node");
        if (removeCategoryIdString != null) {
            this.m_adminCategoryService.removeCategory(removeCategoryIdString);
            return new ModelAndView((View)new RedirectView("/admin/categories.htm", true));
        }
        if (newCategoryName != null) {
            this.m_adminCategoryService.addNewCategory(newCategoryName);
            return new ModelAndView((View)new RedirectView("/admin/categories.htm", true));
        }
        if (categoryIdString != null && editString != null) {
            String editAction = request.getParameter("action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminCategoryService.performEdit(categoryIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((View)new RedirectView("/admin/categories.htm", true));
                modelAndView.addObject("categoryid", (Object)categoryIdString);
                modelAndView.addObject("edit", null);
                return modelAndView;
            }
            DefaultAdminCategoryService.EditModel model = this.m_adminCategoryService.findCategoryAndAllNodes(categoryIdString);
            return new ModelAndView("/admin/editCategory", "model", (Object)model);
        }
        if (categoryIdString != null) {
            return new ModelAndView("/admin/showCategory", "model", (Object)this.m_adminCategoryService.getCategory(categoryIdString));
        }
        if (nodeIdString != null && editString != null) {
            String editAction = request.getParameter("action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminCategoryService.performNodeEdit(nodeIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((View)new RedirectView("/admin/categories.htm", true));
                modelAndView.addObject("node", (Object)nodeIdString);
                modelAndView.addObject("edit", null);
                return modelAndView;
            }
            DefaultAdminCategoryService.NodeEditModel model = this.m_adminCategoryService.findNodeCategories(nodeIdString);
            return new ModelAndView("/admin/editNodeCategories", "model", (Object)model);
        }
        List<OnmsCategory> sortedCategories = this.m_adminCategoryService.findAllCategories();
        return new ModelAndView("/admin/categories", "categories", sortedCategories);
    }

    public AdminCategoryService getAdminCategoryService() {
        return this.m_adminCategoryService;
    }

    public void setAdminCategoryService(AdminCategoryService adminCategoryService) {
        this.m_adminCategoryService = adminCategoryService;
    }
}

