/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryModel;

public class RTCDebugServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected CategoryModel model;

    public void init() throws ServletException {
        try {
            this.model = CategoryModel.getInstance();
        }
        catch (IOException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
        catch (MarshalException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String categoryName = request.getParameter("category");
        if (categoryName == null) {
            categoryName = "Overall Service Availability";
        }
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Category category = this.model.getCategory(categoryName);
        if (category == null) {
            out.write("No data exists for this category.  Please check your spelling of the category name.");
        } else {
            try {
                Marshaller.marshal((Object)category.getRtcCategory(), (Writer)out);
            }
            catch (MarshalException e) {
                throw new ServletException("Could not marshal the RTC info", (Throwable)e);
            }
            catch (ValidationException e) {
                throw new ServletException("Could not marshal the RTC info", (Throwable)e);
            }
        }
        out.close();
    }
}

