/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.asset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.MissingParameterException;
import org.opennms.web.Util;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.asset.Asset;
import org.opennms.web.asset.AssetModel;

public class ModifyAssetServlet
extends HttpServlet {
    private static final long serialVersionUID = 9203659232262966182L;
    private static Set<String> s_allowHtmlFields;
    protected AssetModel model;

    public void init() throws ServletException {
        this.model = new AssetModel();
        this.initAllowHtmlFields();
    }

    private void initAllowHtmlFields() {
        s_allowHtmlFields = new HashSet<String>();
        String allowHtmlFieldNames = System.getProperty("opennms.assets.allowHtmlFields");
        if (allowHtmlFieldNames == null) {
            return;
        }
        for (String fieldName : allowHtmlFieldNames.split("\\s*,\\s*")) {
            s_allowHtmlFields.add(fieldName.toLowerCase());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String isNewString = request.getParameter("isnew");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "isnew"});
        }
        if (isNewString == null) {
            throw new MissingParameterException("isnew", new String[]{"node", "isnew"});
        }
        int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        boolean isNew = Boolean.valueOf(isNewString);
        Asset asset = this.parms2Asset(request, nodeId);
        Event evnt = EventUtils.createAssetInfoChangedEvent((String)"OpenNMS.WebUI", (long)nodeId, (long)-1L);
        this.sendEvent(evnt);
        try {
            if (isNew) {
                this.model.createAsset(asset);
            } else {
                this.model.modifyAsset(asset);
            }
            response.sendRedirect("modify.jsp?node=" + nodeId);
        }
        catch (SQLException e) {
            throw new ServletException("database error", (Throwable)e);
        }
    }

    protected String getRequestParameter(HttpServletRequest request, String name) {
        boolean allowHTML = false;
        if (s_allowHtmlFields.contains(name.toLowerCase())) {
            allowHTML = true;
        }
        return WebSecurityUtils.sanitizeString((String)request.getParameter(name), (boolean)allowHTML);
    }

    protected Asset parms2Asset(HttpServletRequest request, int nodeId) {
        Asset asset = new Asset();
        asset.setNodeId(nodeId);
        asset.setCategory(this.getRequestParameter(request, "category"));
        asset.setManufacturer(this.getRequestParameter(request, "manufacturer"));
        asset.setVendor(this.getRequestParameter(request, "vendor"));
        asset.setModelNumber(this.getRequestParameter(request, "modelnumber"));
        asset.setSerialNumber(this.getRequestParameter(request, "serialnumber"));
        asset.setDescription(this.getRequestParameter(request, "description"));
        asset.setCircuitId(this.getRequestParameter(request, "circuitid"));
        asset.setAssetNumber(this.getRequestParameter(request, "assetnumber"));
        asset.setOperatingSystem(this.getRequestParameter(request, "operatingsystem"));
        asset.setRack(this.getRequestParameter(request, "rack"));
        asset.setSlot(this.getRequestParameter(request, "slot"));
        asset.setPort(this.getRequestParameter(request, "port"));
        asset.setRegion(this.getRequestParameter(request, "region"));
        asset.setDivision(this.getRequestParameter(request, "division"));
        asset.setDepartment(this.getRequestParameter(request, "department"));
        asset.setAddress1(this.getRequestParameter(request, "address1"));
        asset.setAddress2(this.getRequestParameter(request, "address2"));
        asset.setCity(this.getRequestParameter(request, "city"));
        asset.setState(this.getRequestParameter(request, "state"));
        asset.setZip(this.getRequestParameter(request, "zip"));
        asset.setBuilding(this.getRequestParameter(request, "building"));
        asset.setFloor(this.getRequestParameter(request, "floor"));
        asset.setRoom(this.getRequestParameter(request, "room"));
        asset.setVendorPhone(this.getRequestParameter(request, "vendorphone"));
        asset.setVendorFax(this.getRequestParameter(request, "vendorfax"));
        asset.setDateInstalled(this.getRequestParameter(request, "dateinstalled"));
        asset.setLease(this.getRequestParameter(request, "lease"));
        asset.setLeaseExpires(this.getRequestParameter(request, "leaseexpires"));
        asset.setSupportPhone(this.getRequestParameter(request, "supportphone"));
        asset.setMaintContract(this.getRequestParameter(request, "maintcontract"));
        asset.setVendorAssetNumber(this.getRequestParameter(request, "vendorassetnumber"));
        asset.setMaintContractExpires(this.getRequestParameter(request, "maintcontractexpires"));
        asset.setDisplayCategory(this.getRequestParameter(request, "displaycategory"));
        asset.setNotifyCategory(this.getRequestParameter(request, "notifycategory"));
        asset.setPollerCategory(this.getRequestParameter(request, "pollercategory"));
        asset.setThresholdCategory(this.getRequestParameter(request, "thresholdcategory"));
        asset.setComments(this.getRequestParameter(request, "comments"));
        asset.setUsername(this.getRequestParameter(request, "username"));
        asset.setPassword(this.getRequestParameter(request, "password"));
        asset.setEnable(this.getRequestParameter(request, "enable"));
        asset.setConnection(this.getRequestParameter(request, "connection"));
        asset.setAutoenable(this.getRequestParameter(request, "autoenable"));
        asset.setUserLastModified(request.getRemoteUser());
        asset.setLastModifiedDate(new Date());
        return asset;
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Exception e) {
            throw new ServletException("Could not send event " + event.getUei(), (Throwable)e);
        }
    }
}

