/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.asset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.asset.Asset;
import org.springframework.util.Assert;

public class AssetModel {
    private static final String[][] s_columns = new String[][]{{"Address 1", "address1"}, {"Address 2", "address2"}, {"Asset Number", "assetNumber"}, {"Building", "building"}, {"Circuit ID", "circuitId"}, {"City", "city"}, {"Comments", "comment"}, {"Date Installed", "dateInstalled"}, {"Department", "department"}, {"Description", "description"}, {"Display Category", "displayCategory"}, {"Division", "division"}, {"Floor", "floor"}, {"Lease", "lease"}, {"Lease Expires", "leaseExpires"}, {"Maint Contract", "maintContract"}, {"Maint Contract Expires", "maintContractExpires"}, {"Maint Phone", "supportPhone"}, {"Manufacturer", "manufacturer"}, {"Model Number", "modelNumber"}, {"Notification Category", "notifyCategory"}, {"Operating System", "operatingSystem"}, {"Port", "port"}, {"Poller Category", "pollerCategory"}, {"Rack", "rack"}, {"Region", "region"}, {"Room", "room"}, {"Serial Number", "serialNumber"}, {"Slot", "slot"}, {"State", "state"}, {"Threshold Category", "thresholdCategory"}, {"User Last Modified", "userLastModified"}, {"Vendor", "vendor"}, {"Vendor Asset Number", "vendorAssetNumber"}, {"Vendor Fax", "vendorFax"}, {"Vendor Phone", "vendorPhone"}, {"ZIP Code", "zip"}, {"Username", "username"}, {"Password", "password"}, {"Enable Password", "enable"}, {"Connection type", "connection"}, {"Auto Enable", "autoenable"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset getAsset(int nodeId) throws SQLException {
        Asset asset = null;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM ASSETS WHERE NODEID=" + nodeId);
            Asset[] assets = AssetModel.rs2Assets(rs);
            if (assets.length > 0) {
                asset = assets[0];
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return asset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Asset[] getAllAssets() throws SQLException {
        Asset[] assets = new Asset[]{};
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery("SELECT * FROM ASSETS");
            d.watch((Object)rs);
            assets = AssetModel.rs2Assets(rs);
        }
        finally {
            d.cleanUp();
        }
        return assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAsset(Asset asset) throws SQLException {
        Assert.notNull((Object)asset, (String)"argument asset cannot be null");
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO ASSETS (nodeID,category,manufacturer,vendor,modelNumber,serialNumber,description,circuitId,assetNumber,operatingSystem,rack,slot,port,region,division,department,address1,address2,city,state,zip,building,floor,room,vendorPhone,vendorFax,userLastModified,lastModifiedDate,dateInstalled,lease,leaseExpires,supportPhone,maintContract,vendorAssetNumber,maintContractExpires,displayCategory,notifyCategory,pollerCategory,thresholdCategory,comment,username,password,enable,connection,autoenable) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            d.watch((Object)stmt);
            stmt.setInt(1, asset.nodeId);
            stmt.setString(2, asset.category);
            stmt.setString(3, asset.manufacturer);
            stmt.setString(4, asset.vendor);
            stmt.setString(5, asset.modelNumber);
            stmt.setString(6, asset.serialNumber);
            stmt.setString(7, asset.description);
            stmt.setString(8, asset.circuitId);
            stmt.setString(9, asset.assetNumber);
            stmt.setString(10, asset.operatingSystem);
            stmt.setString(11, asset.rack);
            stmt.setString(12, asset.slot);
            stmt.setString(13, asset.port);
            stmt.setString(14, asset.region);
            stmt.setString(15, asset.division);
            stmt.setString(16, asset.department);
            stmt.setString(17, asset.address1);
            stmt.setString(18, asset.address2);
            stmt.setString(19, asset.city);
            stmt.setString(20, asset.state);
            stmt.setString(21, asset.zip);
            stmt.setString(22, asset.building);
            stmt.setString(23, asset.floor);
            stmt.setString(24, asset.room);
            stmt.setString(25, asset.vendorPhone);
            stmt.setString(26, asset.vendorFax);
            stmt.setString(27, asset.userLastModified);
            stmt.setTimestamp(28, new Timestamp(asset.lastModifiedDate.getTime()));
            stmt.setString(29, asset.dateInstalled);
            stmt.setString(30, asset.lease);
            stmt.setString(31, asset.leaseExpires);
            stmt.setString(32, asset.supportPhone);
            stmt.setString(33, asset.maintContract);
            stmt.setString(34, asset.vendorAssetNumber);
            stmt.setString(35, asset.maintContractExpires);
            stmt.setString(36, asset.displayCategory);
            stmt.setString(37, asset.notifyCategory);
            stmt.setString(38, asset.pollerCategory);
            stmt.setString(39, asset.thresholdCategory);
            stmt.setString(40, asset.comments);
            stmt.setString(41, asset.username);
            stmt.setString(42, asset.password);
            stmt.setString(43, asset.enable);
            stmt.setString(44, asset.connection);
            stmt.setString(45, asset.autoenable);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAsset(Asset asset) throws SQLException {
        Assert.notNull((Object)asset, (String)"argument asset cannot be null");
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE ASSETS SET category=?,manufacturer=?,vendor=?,modelNumber=?,serialNumber=?,description=?,circuitId=?,assetNumber=?,operatingSystem=?,rack=?,slot=?,port=?,region=?,division=?,department=?,address1=?,address2=?,city=?,state=?,zip=?,building=?,floor=?,room=?,vendorPhone=?,vendorFax=?,userLastModified=?,lastModifiedDate=?,dateInstalled=?,lease=?,leaseExpires=?,supportPhone=?,maintContract=?,vendorAssetNumber=?,maintContractExpires=?,displayCategory=?,notifyCategory=?,pollerCategory=?,thresholdCategory=?,comment=?, username=?, password=?,enable=?,connection=?,autoenable=? WHERE nodeid=?");
            d.watch((Object)stmt);
            stmt.setString(1, asset.category);
            stmt.setString(2, asset.manufacturer);
            stmt.setString(3, asset.vendor);
            stmt.setString(4, asset.modelNumber);
            stmt.setString(5, asset.serialNumber);
            stmt.setString(6, asset.description);
            stmt.setString(7, asset.circuitId);
            stmt.setString(8, asset.assetNumber);
            stmt.setString(9, asset.operatingSystem);
            stmt.setString(10, asset.rack);
            stmt.setString(11, asset.slot);
            stmt.setString(12, asset.port);
            stmt.setString(13, asset.region);
            stmt.setString(14, asset.division);
            stmt.setString(15, asset.department);
            stmt.setString(16, asset.address1);
            stmt.setString(17, asset.address2);
            stmt.setString(18, asset.city);
            stmt.setString(19, asset.state);
            stmt.setString(20, asset.zip);
            stmt.setString(21, asset.building);
            stmt.setString(22, asset.floor);
            stmt.setString(23, asset.room);
            stmt.setString(24, asset.vendorPhone);
            stmt.setString(25, asset.vendorFax);
            stmt.setString(26, asset.userLastModified);
            stmt.setTimestamp(27, new Timestamp(asset.lastModifiedDate.getTime()));
            stmt.setString(28, asset.dateInstalled);
            stmt.setString(29, asset.lease);
            stmt.setString(30, asset.leaseExpires);
            stmt.setString(31, asset.supportPhone);
            stmt.setString(32, asset.maintContract);
            stmt.setString(33, asset.vendorAssetNumber);
            stmt.setString(34, asset.maintContractExpires);
            stmt.setString(35, asset.displayCategory);
            stmt.setString(36, asset.notifyCategory);
            stmt.setString(37, asset.pollerCategory);
            stmt.setString(38, asset.thresholdCategory);
            stmt.setString(39, asset.comments);
            stmt.setString(40, asset.username);
            stmt.setString(41, asset.password);
            stmt.setString(42, asset.enable);
            stmt.setString(43, asset.connection);
            stmt.setString(44, asset.autoenable);
            stmt.setInt(45, asset.nodeId);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatchingAsset[] searchAssets(String columnName, String searchText) throws SQLException {
        Assert.notNull((Object)columnName, (String)"argument columnName cannot be null");
        Assert.notNull((Object)searchText, (String)"argument searchText cannot be null");
        ArrayList<MatchingAsset> list = new ArrayList<MatchingAsset>();
        columnName = WebSecurityUtils.sanitizeDbColumnName((String)columnName);
        DBUtils d = new DBUtils(AssetModel.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT ASSETS.NODEID, NODE.NODELABEL, ASSETS." + columnName + " FROM ASSETS, NODE WHERE LOWER(ASSETS." + columnName + ") LIKE ? AND ASSETS.NODEID=NODE.NODEID ORDER BY NODE.NODELABEL");
            d.watch((Object)stmt);
            stmt.setString(1, "%" + searchText.toLowerCase() + "%");
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                MatchingAsset asset = new MatchingAsset();
                asset.nodeId = rs.getInt("nodeID");
                asset.nodeLabel = rs.getString("nodelabel");
                asset.matchingValue = rs.getString(columnName);
                asset.columnSearched = columnName;
                list.add(asset);
            }
        }
        finally {
            d.cleanUp();
        }
        return list.toArray(new MatchingAsset[list.size()]);
    }

    protected static Asset[] rs2Assets(ResultSet rs) throws SQLException {
        ArrayList<Asset> list = new ArrayList<Asset>();
        while (rs.next()) {
            Asset asset = new Asset();
            asset.nodeId = rs.getInt("nodeID");
            asset.setCategory(rs.getString("category"));
            asset.setManufacturer(rs.getString("manufacturer"));
            asset.setVendor(rs.getString("vendor"));
            asset.setModelNumber(rs.getString("modelNumber"));
            asset.setSerialNumber(rs.getString("serialNumber"));
            asset.setDescription(rs.getString("description"));
            asset.setCircuitId(rs.getString("circuitId"));
            asset.setAssetNumber(rs.getString("assetNumber"));
            asset.setOperatingSystem(rs.getString("operatingSystem"));
            asset.setRack(rs.getString("rack"));
            asset.setSlot(rs.getString("slot"));
            asset.setPort(rs.getString("port"));
            asset.setRegion(rs.getString("region"));
            asset.setDivision(rs.getString("division"));
            asset.setDepartment(rs.getString("department"));
            asset.setAddress1(rs.getString("address1"));
            asset.setAddress2(rs.getString("address2"));
            asset.setCity(rs.getString("city"));
            asset.setState(rs.getString("state"));
            asset.setZip(rs.getString("zip"));
            asset.setBuilding(rs.getString("building"));
            asset.setFloor(rs.getString("floor"));
            asset.setRoom(rs.getString("room"));
            asset.setVendorPhone(rs.getString("vendorPhone"));
            asset.setVendorFax(rs.getString("vendorFax"));
            asset.setUserLastModified(rs.getString("userLastModified"));
            asset.setLease(rs.getString("lease"));
            asset.setSupportPhone(rs.getString("supportPhone"));
            asset.setMaintContract(rs.getString("maintContract"));
            asset.setDateInstalled(rs.getString("dateInstalled"));
            asset.setLeaseExpires(rs.getString("leaseExpires"));
            asset.setMaintContractExpires(rs.getString("maintContractExpires"));
            asset.setVendorAssetNumber(rs.getString("vendorAssetNumber"));
            asset.setDisplayCategory(rs.getString("displayCategory"));
            asset.setNotifyCategory(rs.getString("notifyCategory"));
            asset.setPollerCategory(rs.getString("pollerCategory"));
            asset.setThresholdCategory(rs.getString("thresholdCategory"));
            asset.setComments(rs.getString("comment"));
            asset.setUsername(rs.getString("username"));
            asset.setPassword(rs.getString("password"));
            asset.setEnable(rs.getString("enable"));
            asset.setConnection(rs.getString("connection"));
            asset.setAutoenable(rs.getString("autoenable"));
            asset.lastModifiedDate = new Date(rs.getTimestamp("lastModifiedDate").getTime());
            list.add(asset);
        }
        return list.toArray(new Asset[list.size()]);
    }

    public static String[][] getColumns() {
        return s_columns;
    }

    private static boolean isColumnValid(String column) {
        Assert.notNull((Object)column, (String)"argument column cannot be null");
        for (String[] assetColumn : s_columns) {
            if (!column.equals(assetColumn[1])) continue;
            return true;
        }
        return false;
    }

    public static class MatchingAsset {
        public int nodeId;
        public String nodeLabel;
        public String matchingValue;
        public String columnSearched;
    }
}

