/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.Date;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;

public class Alarm {
    public static final int PROBLEM_TYPE = 1;
    public static final int RESOLUTION_TYPE = 2;
    protected int id;
    protected String uei;
    protected String dpName;
    protected Integer nodeID;
    protected String ipAddr;
    protected Integer serviceID;
    protected String reductionKey;
    protected int count;
    protected OnmsSeverity severity;
    protected int lastEventID;
    protected Date firsteventtime;
    protected Date lasteventtime;
    protected String description;
    protected String logMessage;
    protected String operatorInstruction;
    protected String troubleTicket;
    protected TroubleTicketState troubleTicketState;
    protected String mouseOverText;
    protected Date suppressedUntil;
    protected String suppressedUser;
    protected Date suppressedTime;
    protected String acknowledgeUser;
    protected Date acknowledgeTime;
    protected String parms;
    protected String serviceName;
    protected String nodeLabel;

    public Alarm() {
    }

    public Alarm(int id, String uei, String dpName, Date lasteventtime, Date firsteventtime, int count, int severityId) {
        if (uei == null || dpName == null || lasteventtime == null || firsteventtime == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.id = id;
        this.uei = uei;
        this.dpName = dpName;
        this.lasteventtime = lasteventtime;
        this.firsteventtime = firsteventtime;
        this.count = count;
        this.severity = OnmsSeverity.get((int)severityId);
    }

    public Alarm(int id, String uei, String dpName, Integer nodeID, String ipAddr, Integer serviceID, String reductionKey, int count, int severity, int lastEventID, Date firsteventtime, Date lasteventtime, String description, String logMessage, String operatorInstruction, String troubleTicket, TroubleTicketState troubleTicketState, String mouseOverText, Date suppressedUntil, String suppressedUser, Date suppressedTime, String acknowledgeUser, Date acknowledgeTime, String parms) {
        this(id, uei, dpName, nodeID, ipAddr, serviceID, reductionKey, count, severity, lastEventID, firsteventtime, lasteventtime, description, logMessage, operatorInstruction, troubleTicket, troubleTicketState, mouseOverText, suppressedUntil, suppressedUser, suppressedTime, acknowledgeUser, acknowledgeTime, parms, null, null);
    }

    public Alarm(int id, String uei, String dpName, Integer nodeID, String ipAddr, Integer serviceID, String reductionKey, int count, int severityId, int lastEventID, Date firsteventtime, Date lasteventtime, String description, String logMessage, String operatorInstruction, String troubleTicket, TroubleTicketState troubleTicketState, String mouseOverText, Date suppressedUntil, String suppressedUser, Date suppressedTime, String acknowledgeUser, Date acknowledgeTime, String parms, String nodeLabel, String serviceName) {
        if (uei == null || dpName == null || lasteventtime == null || firsteventtime == null) {
            throw new IllegalArgumentException("Cannot take null values for the following parameters: uei, dpName, firsteventtime, lasteventtime.");
        }
        this.id = id;
        this.uei = uei;
        this.dpName = dpName;
        this.lasteventtime = lasteventtime;
        this.firsteventtime = firsteventtime;
        this.count = count;
        this.severity = OnmsSeverity.get((int)severityId);
        this.nodeID = nodeID;
        this.ipAddr = ipAddr;
        this.serviceID = serviceID;
        this.reductionKey = reductionKey;
        this.lastEventID = lastEventID;
        this.description = description;
        this.logMessage = logMessage;
        this.operatorInstruction = operatorInstruction;
        this.troubleTicket = troubleTicket;
        this.troubleTicketState = troubleTicketState;
        this.mouseOverText = mouseOverText;
        this.suppressedUntil = suppressedUntil;
        this.suppressedUser = suppressedUser;
        this.suppressedTime = suppressedTime;
        this.acknowledgeUser = acknowledgeUser;
        this.acknowledgeTime = acknowledgeTime;
        this.parms = parms;
        this.nodeLabel = nodeLabel;
        this.serviceName = serviceName;
    }

    public int getId() {
        return this.id;
    }

    public String getUei() {
        return this.uei;
    }

    public String getDpName() {
        return this.dpName;
    }

    public Date getLastEventTime() {
        return this.lasteventtime;
    }

    public Date getFirstEventTime() {
        return this.firsteventtime;
    }

    public int getCount() {
        return this.count;
    }

    public OnmsSeverity getSeverity() {
        return this.severity;
    }

    public int getNodeId() {
        return this.nodeID;
    }

    public String getIpAddress() {
        return this.ipAddr;
    }

    public int getServiceId() {
        return this.serviceID;
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public int getLastEventID() {
        return this.lastEventID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String getOperatorInstruction() {
        return this.operatorInstruction;
    }

    public String getTroubleTicket() {
        return this.troubleTicket;
    }

    public TroubleTicketState getTroubleTicketState() {
        return this.troubleTicketState;
    }

    public String getMouseOverText() {
        return this.mouseOverText;
    }

    public Date getSuppressedUntil() {
        return this.suppressedUntil;
    }

    public String getSuppressedUser() {
        return this.suppressedUser;
    }

    public Date getSuppressedTime() {
        return this.suppressedTime;
    }

    public String getAcknowledgeUser() {
        return this.acknowledgeUser;
    }

    public Date getAcknowledgeTime() {
        return this.acknowledgeTime;
    }

    public boolean isAcknowledged() {
        return this.acknowledgeUser != null;
    }

    public String getParms() {
        return this.parms;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

