/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users.parsers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.opennms.web.admin.users.parsers.DutySchedule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationInfo
implements Cloneable {
    private String m_email = "";
    private String m_pagerEmail = "";
    private String m_xmppAddress = "";
    private String m_numericalService = "";
    private String m_numericalPin = "";
    private String m_textService = "";
    private String m_textPin = "";
    private List<DutySchedule> m_dutySchedules = new ArrayList<DutySchedule>();

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        NotificationInfo newInfo = new NotificationInfo();
        newInfo.setEmail(this.m_email);
        newInfo.setPagerEmail(this.m_pagerEmail);
        newInfo.setXMPPAddress(this.m_xmppAddress);
        newInfo.setNumericalService(this.m_numericalService);
        newInfo.setNumericalPin(this.m_numericalPin);
        newInfo.setTextService(this.m_textService);
        newInfo.setTextPin(this.m_textPin);
        for (DutySchedule dutySchedule : this.m_dutySchedules) {
            newInfo.addDutySchedule(dutySchedule.clone());
        }
        return newInfo;
    }

    public void setEmail(String anEmail) {
        this.m_email = anEmail;
    }

    public void setPagerEmail(String anEmail) {
        this.m_pagerEmail = anEmail;
    }

    public void setXMPPAddress(String anAddress) {
        this.m_xmppAddress = anAddress;
    }

    public void setNumericalService(String aService) {
        this.m_numericalService = aService;
    }

    public void setNumericalPin(String aPin) {
        this.m_numericalPin = aPin;
    }

    public void setTextService(String aService) {
        this.m_textService = aService;
    }

    public void setTextPin(String aPin) {
        this.m_textPin = aPin;
    }

    public void addDutySchedule(DutySchedule aSchedule) {
        this.m_dutySchedules.add(aSchedule);
    }

    public void setDutySchedule(List<DutySchedule> someSchedules) {
        this.m_dutySchedules = someSchedules;
    }

    public String getEmail() {
        return this.m_email;
    }

    public String getPagerEmail() {
        return this.m_pagerEmail;
    }

    public String getXMPPAddress() {
        return this.m_xmppAddress;
    }

    public String getNumericalService() {
        return this.m_numericalService;
    }

    public String getNumericalPin() {
        return this.m_numericalPin;
    }

    public String getTextService() {
        return this.m_textService;
    }

    public String getTextPin() {
        return this.m_textPin;
    }

    public int getDutyScheduleCount() {
        return this.m_dutySchedules.size();
    }

    public List<DutySchedule> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public boolean isOnDuty(Calendar aTime) {
        DutySchedule curSchedule;
        boolean result = false;
        if (this.m_dutySchedules.size() == 0) {
            return true;
        }
        Iterator<DutySchedule> i$ = this.m_dutySchedules.iterator();
        while (i$.hasNext() && !(result = (curSchedule = i$.next()).isInSchedule(aTime))) {
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("email             = " + this.m_email + "\n");
        buffer.append("xmpp              = " + this.m_xmppAddress + "\n");
        buffer.append("numerical service = " + this.m_numericalService + "\n");
        buffer.append("numerical pin     = " + this.m_numericalPin + "\n");
        buffer.append("text service      = " + this.m_textService + "\n");
        buffer.append("text pin          = " + this.m_textPin + "\n");
        for (DutySchedule dutySchedule : this.m_dutySchedules) {
            buffer.append(dutySchedule.toString() + "\n");
        }
        return buffer.toString();
    }
}

