/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.pollerConfig;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private PollerConfiguration m_pollerConfig = null;
    private CapsdConfiguration m_capsdConfig = null;
    protected String m_redirectSuccess;
    private Map<String, Service> m_pollerServices = new HashMap<String, Service>();
    private Map<String, ProtocolPlugin> m_capsdProtocols = new HashMap<String, ProtocolPlugin>();
    private List<ProtocolPlugin> m_capsdColl = new ArrayList<ProtocolPlugin>();
    private Package m_pkg = null;
    private List<ProtocolPlugin> m_pluginColl = null;
    private Properties m_props = new Properties();
    private PollerConfig m_pollerFactory = null;
    private CapsdConfig m_capsdFactory = null;

    public void init() throws ServletException {
        this.getInitParameters();
        this.loadPollerConfProperties();
        this.initPollerConfigFactory();
        this.initCapsdConfigFactory();
        this.initPollerServices();
        this.initCapsdProtocols();
    }

    private void getInitParameters() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.m_redirectSuccess = config.getInitParameter("redirect.success");
        if (this.m_redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    private void initCapsdConfigFactory() throws ServletException {
        try {
            CapsdConfigFactory.init();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.m_capsdFactory = CapsdConfigFactory.getInstance();
        this.m_capsdConfig = this.m_capsdFactory.getConfiguration();
        if (this.m_capsdConfig == null) {
            throw new ServletException("Capsd Configuration file is empty");
        }
    }

    private void initPollerConfigFactory() throws ServletException {
        try {
            PollerConfigFactory.init();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.m_pollerFactory = PollerConfigFactory.getInstance();
        this.m_pollerConfig = this.m_pollerFactory.getConfiguration();
        if (this.m_pollerConfig == null) {
            throw new ServletException("Poller Configuration file is empty");
        }
    }

    private void loadPollerConfProperties() throws ServletException {
        try {
            this.m_props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void reloadFiles() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.loadPollerConfProperties();
            this.initPollerConfigFactory();
            this.initCapsdConfigFactory();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.m_redirectSuccess = config.getInitParameter("redirect.success");
        if (this.m_redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void initCapsdProtocols() {
        this.m_pluginColl = this.getCapsdProtocolPlugins();
        if (this.m_pluginColl != null) {
            for (ProtocolPlugin plugin : this.m_pluginColl) {
                this.m_capsdColl.add(plugin);
                this.m_capsdProtocols.put(plugin.getProtocol(), plugin);
            }
        }
    }

    private List<ProtocolPlugin> getCapsdProtocolPlugins() {
        return this.m_capsdConfig.getProtocolPluginCollection();
    }

    public void initPollerServices() {
        Iterator pkgiter;
        List packageColl = this.m_pollerConfig.getPackageCollection();
        if (packageColl != null && (pkgiter = packageColl.iterator()).hasNext()) {
            this.m_pkg = (Package)pkgiter.next();
            List svcColl = this.m_pkg.getServiceCollection();
            Iterator svcIter = svcColl.iterator();
            Service svcProp = null;
            while (svcIter.hasNext()) {
                svcProp = (Service)svcIter.next();
                this.m_pollerServices.put(svcProp.getName(), svcProp);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reloadFiles();
        ArrayList<String> checkedList = new ArrayList<String>();
        ArrayList<String> deleteList = new ArrayList<String>();
        this.m_props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        String[] requestActivate = request.getParameterValues("activate");
        String[] requestDelete = request.getParameterValues("delete");
        if (requestActivate != null) {
            for (int i = 0; i < requestActivate.length; ++i) {
                this.modifyPollerInfo("on", requestActivate[i]);
                checkedList.add(requestActivate[i]);
            }
        }
        if (requestDelete != null) {
            for (int j = 0; j < requestDelete.length; ++j) {
                deleteList.add(requestDelete[j]);
            }
        }
        this.adjustNonChecked(checkedList);
        this.deleteThese(deleteList);
        OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), "UTF-8");
        OutputStreamWriter capsd_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME)), "UTF-8");
        try {
            Marshaller.marshal((Object)this.m_pollerConfig, (Writer)poller_fileWriter);
            Marshaller.marshal((Object)this.m_capsdConfig, (Writer)capsd_fileWriter);
        }
        catch (MarshalException e) {
            this.log().error("Could not marshal config object when writing config file: " + (Object)((Object)e), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (ValidationException e) {
            this.log().error("Could not validate config object when writing config file: " + (Object)((Object)e), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        String redirectPage = request.getParameter("redirect");
        if (redirectPage == null) {
            redirectPage = this.m_redirectSuccess;
        }
        response.sendRedirect(redirectPage);
    }

    public void deleteCapsdInfo(String name) {
        if (this.m_capsdProtocols.get(name) != null) {
            ProtocolPlugin tmpproto = this.m_capsdProtocols.get(name);
            this.m_capsdProtocols.remove(name);
            this.m_pluginColl = new ArrayList<ProtocolPlugin>(this.m_capsdProtocols.values());
            this.m_capsdColl.remove(tmpproto);
            this.m_capsdConfig.setProtocolPlugin(this.m_pluginColl.toArray(new ProtocolPlugin[0]));
        }
    }

    public void adjustNonChecked(List<String> checkedList) {
        if (this.m_pkg != null) {
            List svcColl = this.m_pkg.getServiceCollection();
            Service svc2 = null;
            if (svcColl != null) {
                for (Service svc2 : svcColl) {
                    if (svc2 == null || checkedList.contains(svc2.getName()) || !svc2.getStatus().equals("on")) continue;
                    svc2.setStatus("off");
                }
            }
        }
    }

    public void deleteThese(List<String> deleteServices) throws IOException {
        ListIterator<String> lstIter = deleteServices.listIterator();
        while (lstIter.hasNext()) {
            String svcname = lstIter.next();
            if (this.m_pkg == null) continue;
            boolean flag = false;
            List svcColl = this.m_pkg.getServiceCollection();
            if (svcColl == null) continue;
            Iterator svcIter = svcColl.iterator();
            Service svc = null;
            while (svcIter.hasNext()) {
                svc = (Service)svcIter.next();
                if (svc == null || !svc.getName().equals(svcname)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            this.m_pkg.removeService(svc);
            this.log().info("Package removed " + svc.getName());
            this.removeMonitor(svc.getName());
            this.deleteCapsdInfo(svc.getName());
            this.m_props.remove("service." + svc.getName() + ".protocol");
            this.m_props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        }
    }

    public void removeMonitor(String service) {
        List monitorColl = this.m_pollerConfig.getMonitorCollection();
        Monitor newMonitor = new Monitor();
        if (monitorColl != null) {
            for (Monitor mon : monitorColl) {
                if (mon == null || !mon.getService().equals(service)) continue;
                newMonitor.setService(service);
                newMonitor.setClassName(mon.getClassName());
                newMonitor.setParameter(mon.getParameterCollection());
                break;
            }
            monitorColl.remove(newMonitor);
        }
    }

    public void modifyPollerInfo(String bPolled, String protocol) {
        List svcColl;
        if (this.m_pkg != null && (svcColl = this.m_pkg.getServiceCollection()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(protocol)) continue;
                svc.setStatus(bPolled);
                break;
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

