/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.notification;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.WebSecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceNoticeUpdateServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String UPDATE_SERVICE = "UPDATE ifservices SET notify = ? WHERE nodeID = ? AND ipaddr = ? AND serviceid = ?";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        Map<String, String> servicesCheckedMap = this.getServicesChecked(userSession);
        String[] checkedServices = request.getParameterValues("serviceCheck");
        if (checkedServices != null) {
            for (String checkedService : checkedServices) {
                servicesCheckedMap.put(checkedService, "Y");
            }
        }
        for (String key : servicesCheckedMap.keySet()) {
            StringTokenizer tokenizer = new StringTokenizer(key, ",");
            int nodeID = WebSecurityUtils.safeParseInt((String)tokenizer.nextToken());
            String ipAddress = tokenizer.nextToken();
            int serviceID = WebSecurityUtils.safeParseInt((String)tokenizer.nextToken());
            this.updateService(nodeID, ipAddress, serviceID, servicesCheckedMap.get(key));
        }
        response.sendRedirect("index.jsp");
    }

    private Map<String, String> getServicesChecked(HttpSession userSession) {
        return (Map)userSession.getAttribute("service.notify.map");
    }

    private void updateService(int nodeID, String interfaceIP, int serviceID, String notifyFlag) throws ServletException {
        Connection connection = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = Vault.getDbConnection();
            d.watch((Object)connection);
            PreparedStatement stmt = connection.prepareStatement(UPDATE_SERVICE);
            d.watch((Object)stmt);
            stmt.setString(1, notifyFlag);
            stmt.setInt(2, nodeID);
            stmt.setString(3, interfaceIP);
            stmt.setInt(4, serviceID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqlEx) {
                throw new ServletException("Couldn't roll back update to service " + serviceID + " on interface " + interfaceIP + " notify as " + notifyFlag + " in the database.", (Throwable)sqlEx);
            }
            throw new ServletException("Error when updating to service " + serviceID + " on interface " + interfaceIP + " notify as " + notifyFlag + " in the database.", (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
    }
}

