/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.Util;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.admin.nodeManagement.SnmpManagedInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpManageNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1604691299928314549L;
    private static final String UPDATE_INTERFACE = "UPDATE snmpInterface SET snmpCollect = ? WHERE id = ?";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Exception e) {
            throw new ServletException("Could not initialize database factory: " + e.getMessage(), (Throwable)e);
        }
        try {
            NotificationFactory.init();
        }
        catch (Exception e) {
            throw new ServletException("Could not initialize notification factory: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        List<SnmpManagedInterface> allInterfaces = this.getManagedInterfacesFromSession(userSession);
        String nodeIdString = request.getParameter("node");
        int currNodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        String primeInt = null;
        for (SnmpManagedInterface testInterface : allInterfaces) {
            if (testInterface.getNodeid() != currNodeId || !"P".equals(testInterface.getStatus())) continue;
            primeInt = testInterface.getAddress();
        }
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection connection = Vault.getDbConnection();
            d.watch((Object)connection);
            try {
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(UPDATE_INTERFACE);
                d.watch((Object)stmt);
                for (SnmpManagedInterface curInterface : allInterfaces) {
                    String option = request.getParameter("collect-" + curInterface.getIfIndex());
                    System.err.println(String.format("option = %s", option));
                    stmt.setString(1, option);
                    stmt.setInt(2, curInterface.getSnmpInterfaceId());
                    stmt.execute();
                }
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        if (primeInt != null) {
            this.sendSNMPRestartEvent(currNodeId, primeInt);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/element/node.jsp?node=" + currNodeId);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<SnmpManagedInterface> getManagedInterfacesFromSession(HttpSession userSession) {
        if (userSession == null) {
            return null;
        }
        return (List)userSession.getAttribute("listInterfacesForNode.snmpselect.jsp");
    }

    private void sendSNMPRestartEvent(int nodeid, String primeInt) throws ServletException {
        Event snmpRestart = new Event();
        snmpRestart.setUei("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        snmpRestart.setNodeid((long)nodeid);
        snmpRestart.setInterface(primeInt);
        snmpRestart.setSource("web ui");
        snmpRestart.setTime(EventConstants.formatToString((Date)new Date()));
        this.sendEvent(snmpRestart);
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Exception e) {
            throw new ServletException("Could not send event " + event.getUei(), (Throwable)e);
        }
    }
}

