/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.admin.nodeManagement.SnmpManagedInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpGetInterfacesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String INTERFACE_QUERY = "SELECT snmpinterface.nodeid, snmpinterface.ipaddr, snmpinterface.snmpifindex, ipinterface.iphostname, ipinterface.issnmpprimary, snmpinterface.snmpifdescr, snmpinterface.snmpiftype, snmpinterface.snmpifname, snmpinterface.snmpifalias, snmpinterface.snmpcollect, snmpinterface.id FROM snmpinterface LEFT JOIN ipinterface ON ipinterface.snmpinterfaceid=snmpinterface.id WHERE snmpinterface.nodeid=?";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession user = request.getSession(true);
        String nodeIdString = request.getParameter("node");
        if (nodeIdString == null) {
            throw new MissingParameterException("node");
        }
        int nodeid = WebSecurityUtils.safeParseInt((String)nodeIdString);
        try {
            user.setAttribute("listInterfacesForNode.snmpselect.jsp", this.getNodeInterfaces(user, nodeid));
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpselect.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnmpManagedInterface> getNodeInterfaces(HttpSession userSession, int nodeid) throws SQLException {
        Connection connection = null;
        ArrayList<SnmpManagedInterface> nodeInterfaces = new ArrayList<SnmpManagedInterface>();
        int lineCount = 0;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            PreparedStatement interfaceSelect = connection.prepareStatement(INTERFACE_QUERY);
            d.watch((Object)interfaceSelect);
            interfaceSelect.setInt(1, nodeid);
            ResultSet interfaceSet = interfaceSelect.executeQuery();
            d.watch((Object)interfaceSet);
            if (interfaceSet != null) {
                while (interfaceSet.next()) {
                    ++lineCount;
                    SnmpManagedInterface newInterface = new SnmpManagedInterface();
                    nodeInterfaces.add(newInterface);
                    newInterface.setNodeid(interfaceSet.getInt(1));
                    newInterface.setAddress(interfaceSet.getString(2));
                    newInterface.setIfIndex(interfaceSet.getInt(3));
                    newInterface.setIpHostname(interfaceSet.getString(4));
                    newInterface.setStatus(interfaceSet.getString(5));
                    newInterface.setIfDescr(interfaceSet.getString(6));
                    newInterface.setIfType(interfaceSet.getInt(7));
                    newInterface.setIfName(interfaceSet.getString(8));
                    newInterface.setIfAlias(interfaceSet.getString(9));
                    newInterface.setCollectFlag(interfaceSet.getString(10));
                    newInterface.setSnmpInterfaceId(interfaceSet.getInt(11));
                }
            }
        }
        finally {
            d.cleanUp();
        }
        Collections.sort(nodeInterfaces);
        return nodeInterfaces;
    }
}

