/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.Util;

public class SnmpConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 2824294300141467193L;
    private static final Logger log = Logger.getLogger(SnmpConfigServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String firstIPAddress = request.getParameter("firstIPAddress");
        String lastIPAddress = request.getParameter("lastIPAddress");
        String communityString = request.getParameter("communityString");
        String timeout = request.getParameter("timeout");
        String version = request.getParameter("version");
        String retryCount = request.getParameter("retryCount");
        String port = request.getParameter("port");
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPost: firstIPAddress=" + firstIPAddress + ", " + "lastIPAddress=" + lastIPAddress + ", and " + "communityString=" + communityString));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/configureSNMP");
        newEvent.setSource("web ui");
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        newEvent.setService("SNMP");
        newEvent.setInterface(firstIPAddress);
        EventBuilder builder = new EventBuilder(newEvent);
        builder.addParam("firstIPAddress", firstIPAddress);
        builder.addParam("lastIPAddress", lastIPAddress);
        builder.addParam("communityString", communityString);
        if (timeout.length() > 0) {
            builder.addParam("timeout", timeout);
        }
        if (port.length() > 0) {
            builder.addParam("port", port);
        }
        if (retryCount.length() > 0) {
            builder.addParam("retryCount", retryCount);
        }
        if (version.length() > 0) {
            builder.addParam("version", version);
        }
        try {
            EventProxy eventProxy = Util.createEventProxy();
            if (eventProxy == null) {
                throw new ServletException("Event proxy object is null, unable to send event " + newEvent.getUei());
            }
            eventProxy.send(builder.getEvent());
        }
        catch (Exception e) {
            throw new ServletException("Could not send event " + newEvent.getUei(), (Throwable)e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpConfigured.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

