/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.MissingParameterException;
import org.opennms.web.Util;
import org.opennms.web.WebSecurityUtils;

public class DeleteInterfaceServlet
extends HttpServlet {
    private static final long serialVersionUID = -6492975646540210281L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkParameters(request);
        long nodeId = WebSecurityUtils.safeParseLong((String)request.getParameter("node"));
        String ipAddr = request.getParameter("intf");
        int ifIndex = -1;
        if (request.getParameter("ifindex") != null && request.getParameter("ifindex").length() != 0) {
            ifIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("ifindex"));
        }
        Event e = EventUtils.createDeleteInterfaceEvent((String)"OpenNMS.WebUI", (long)nodeId, (String)ipAddr, (int)ifIndex, (long)-1L);
        this.sendEvent(e);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/interfaceDeleted.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Exception e) {
            throw new ServletException("Could not send event " + event.getUei(), (Throwable)e);
        }
    }

    public void checkParameters(HttpServletRequest request) {
        String nodeIdString = request.getParameter("node");
        String ipAddr = request.getParameter("intf");
        String ifIndex = request.getParameter("ifindex");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "intf or ifindex"});
        }
        if (ipAddr == null && ifIndex == null) {
            throw new MissingParameterException("intf or ifindex", new String[]{"node", "intf or ifindex"});
        }
    }
}

