/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.Util;

public class AddNewInterfaceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String SQL_INTERFACE_EXIST = "SELECT nodeid FROM ipinterface WHERE ipaddr = ? AND ismanaged in ('M', 'A', 'U', 'F')";
    static final String EVENT_SOURCE_VALUE = "Web UI";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Exception e) {
            throw new ServletException("AddNewInterfaceServlet: Error initialising database connection factory." + e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int nodeId = -1;
        String ipAddress = request.getParameter("ipAddress");
        try {
            nodeId = this.getNodeId(ipAddress);
        }
        catch (SQLException sqlE) {
            throw new ServletException("AddInterfaceServlet: failed to query if the ipaddress already exists", (Throwable)sqlE);
        }
        if (nodeId != -1) {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/newInterface.jsp?action=redo");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            this.createAndSendNewSuspectInterfaceEvent(ipAddress);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/interfaceAdded.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void createAndSendNewSuspectInterfaceEvent(String ipaddr) throws ServletException {
        Event event = new Event();
        event.setSource(EVENT_SOURCE_VALUE);
        event.setUei("uei.opennms.org/internal/discovery/newSuspect");
        event.setInterface(ipaddr);
        try {
            event.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            event.setHost("unresolved.host");
        }
        event.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            Util.createEventProxy().send(event);
        }
        catch (Exception e) {
            throw new ServletException("Could not send event " + event.getUei(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNodeId(String ipaddr) throws SQLException {
        int nodeId = -1;
        Connection conn = null;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            stmt = conn.prepareStatement(SQL_INTERFACE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeId = rs.getInt(1);
            }
            int n = nodeId;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }
}

