/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.groups.parsers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opennms.netmgt.config.users.DutySchedule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupInfo {
    private String m_groupName = "";
    private String m_groupComments = "";
    private List<String> m_users = new ArrayList<String>();
    private List<DutySchedule> m_dutySchedules = new Vector<DutySchedule>();

    public void setGroupName(String aName) {
        this.m_groupName = aName;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public void setGroupComments(String someComments) {
        this.m_groupComments = someComments;
    }

    public String getGroupComments() {
        return this.m_groupComments;
    }

    public void addUser(String aUser) {
        this.m_users.add(aUser);
    }

    public void removeUser(String aUser) {
        this.m_users.remove(aUser);
    }

    public List getUsers() {
        return this.m_users;
    }

    public int getUserCount() {
        return this.m_users.size();
    }

    public void addGroupDutySchedule(DutySchedule aSchedule) {
        this.m_dutySchedules.add(aSchedule);
    }

    public void setDutySchedule(List<DutySchedule> someSchedules) {
        this.m_dutySchedules = someSchedules;
    }

    public int getDutyScheduleCount() {
        return this.m_dutySchedules.size();
    }

    public List<DutySchedule> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public boolean isOnDuty(Calendar aTime) {
        DutySchedule curSchedule;
        boolean result = false;
        if (this.m_dutySchedules.size() == 0) {
            return true;
        }
        Iterator<DutySchedule> i$ = this.m_dutySchedules.iterator();
        while (i$.hasNext() && !(result = (curSchedule = i$.next()).isInSchedule(aTime))) {
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name     = " + this.m_groupName + "\n");
        buffer.append("comments = " + this.m_groupComments + "\n");
        buffer.append("users:\n");
        for (String user : this.m_users) {
            buffer.append("\t" + user + "\n");
        }
        for (DutySchedule dutySchedule : this.m_dutySchedules) {
            buffer.append(dutySchedule.toString() + "\n");
        }
        return buffer.toString();
    }
}

