/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.groups;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.GroupManager;

public class RenameGroupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            GroupFactory.init();
        }
        catch (Exception e) {
            throw new ServletException("RenameGroupServlet: Error initialising group factory." + e);
        }
        GroupManager groupFactory = GroupFactory.getInstance();
        String groupName = request.getParameter("groupName");
        String newName = request.getParameter("newName");
        if (newName == null) {
            newName = "";
        }
        boolean hasGroup = false;
        try {
            hasGroup = groupFactory.hasGroup(newName);
        }
        catch (Exception e) {
            throw new ServletException("Can't determine if group " + newName + " already exists in groups.xml.", (Throwable)e);
        }
        if (hasGroup) {
            response.sendRedirect("list.jsp?action=cantrename");
        } else {
            try {
                groupFactory.renameGroup(groupName, newName);
            }
            catch (Exception e) {
                throw new ServletException("Error renaming group " + groupName + " to " + newName, (Throwable)e);
            }
            response.sendRedirect("list.jsp");
        }
    }
}

