/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.DashletView;
import org.opennms.dashboard.client.SurveillanceData;
import org.opennms.dashboard.client.SurveillanceIntersection;
import org.opennms.dashboard.client.SurveillanceListener;
import org.opennms.dashboard.client.SurveillanceListenerCollection;
import org.opennms.dashboard.client.SurveillanceServiceAsync;

public class SurveillanceDashlet
extends Dashlet {
    private SurveillanceListenerCollection m_listeners = new SurveillanceListenerCollection();
    private SurveillanceData m_data;
    private SurveillanceView m_view = new SurveillanceView(this);
    private SurveillanceLoader m_loader = new SurveillanceLoader();

    public SurveillanceDashlet(Dashboard dashboard) {
        super(dashboard, "Surveillance View");
        this.setLoader(this.m_loader);
        this.setView(this.m_view);
    }

    public void setData(SurveillanceData data) {
        this.m_data = data;
        this.m_view.populate(data);
    }

    private void onIntersectionClicked(int row, int col) {
        this.m_listeners.fireIntersectionClicked(this, this.m_data.getIntersection(row, col));
    }

    private void onColumnGroupClicked(int col) {
        this.m_listeners.fireSurveillanceGroupClicked(this, this.m_data.getColumnGroups()[col]);
    }

    private void onRowGroupClicked(int row) {
        this.m_listeners.fireSurveillanceGroupClicked(this, this.m_data.getRowGroups()[row]);
    }

    private void onAllClicked() {
        this.m_listeners.fireAllClicked(this);
    }

    public void addSurveillanceViewListener(SurveillanceListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSurveillanceViewListener(SurveillanceListener listener) {
        this.m_listeners.remove(listener);
    }

    void initialLoader(String serviceEntryPoint) {
        this.m_loader.load();
    }

    public void setSurveillanceService(SurveillanceServiceAsync svc) {
        this.m_loader.setSurveillanceService(svc);
    }

    class SurveillanceView
    extends DashletView {
        private Grid m_grid;

        public SurveillanceView(Dashlet dashlet) {
            super(dashlet);
            this.m_grid = new Grid();
            this.m_grid.addTableListener(new TableListener(){

                public void onCellClicked(SourcesTableEvents table, int row, int col) {
                    SurveillanceView.this.cellClicked(row, col);
                    if (row == 0 && col == 0) {
                        SurveillanceDashlet.this.onAllClicked();
                    } else if (row == 0) {
                        SurveillanceDashlet.this.onColumnGroupClicked(col - 1);
                    } else if (col == 0) {
                        SurveillanceDashlet.this.onRowGroupClicked(row - 1);
                    } else {
                        SurveillanceDashlet.this.onIntersectionClicked(row - 1, col - 1);
                    }
                }
            });
            this.initWidget((Widget)this.m_grid);
        }

        protected void cellClicked(int row, int col) {
            this.clearSelection();
            this.setSelection(row, col);
        }

        private void setSelection(int row, int col) {
            if (row != 0 || col != 0) {
                if (row == 0) {
                    for (int r = 0; r < this.m_grid.getRowCount(); ++r) {
                        this.m_grid.getCellFormatter().addStyleName(r, col, "selected");
                    }
                } else if (col == 0) {
                    for (int c = 0; c < this.m_grid.getColumnCount(); ++c) {
                        this.m_grid.getCellFormatter().addStyleName(row, c, "selected");
                    }
                } else {
                    this.m_grid.getCellFormatter().addStyleName(row, col, "selected");
                }
            }
        }

        private void clearSelection() {
            for (int r = 0; r < this.m_grid.getRowCount(); ++r) {
                for (int c = 0; c < this.m_grid.getColumnCount(); ++c) {
                    this.m_grid.getCellFormatter().removeStyleName(r, c, "selected");
                }
            }
        }

        void populate(SurveillanceData data) {
            this.setTitle(this.getTitle() + ": " + data.getName());
            this.m_grid.resize(data.getRowCount() + 1, data.getColumnCount() + 1);
            this.m_grid.getRowFormatter().setStyleName(0, "header");
            this.m_grid.setText(0, 0, "Show all nodes");
            for (int col = 0; col < data.getColumnCount(); ++col) {
                this.m_grid.setText(0, col + 1, data.getColumnHeading(col));
            }
            for (int row = 0; row < data.getRowCount(); ++row) {
                this.m_grid.setText(row + 1, 0, data.getRowHeading(row));
                for (int col = 0; col < data.getColumnCount(); ++col) {
                    SurveillanceIntersection cell = data.getCell(row, col);
                    this.m_grid.setText(row + 1, col + 1, cell.getData());
                    this.m_grid.getCellFormatter().setStyleName(row + 1, col + 1, cell.getStatus());
                    this.m_grid.getCellFormatter().addStyleName(row + 1, col + 1, "divider");
                }
                this.m_grid.getRowFormatter().setStyleName(row + 1, "CellStatus");
            }
        }
    }

    class SurveillanceLoader
    extends DashletLoader
    implements AsyncCallback {
        private SurveillanceServiceAsync m_surveillanceService;

        SurveillanceLoader() {
        }

        protected void onLoad() {
            this.load();
        }

        public void load() {
            this.loading();
            this.m_surveillanceService.getSurveillanceData(this);
        }

        public void onFailure(Throwable caught) {
            this.loadError(caught);
            SurveillanceDashlet.this.error(caught);
        }

        public void onSuccess(Object result) {
            SurveillanceData data = (SurveillanceData)result;
            SurveillanceDashlet.this.setData(data);
            if (!data.isComplete()) {
                final SurveillanceLoader cb = this;
                Timer timer = new Timer(){

                    public void run() {
                        SurveillanceLoader.this.m_surveillanceService.getSurveillanceData(cb);
                    }
                };
                timer.schedule(2000);
            } else {
                this.complete();
            }
        }

        public void setSurveillanceService(SurveillanceServiceAsync surveillanceService) {
            this.m_surveillanceService = surveillanceService;
        }
    }
}

