/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Pageable;

public class Pager
extends Composite {
    private DockPanel m_panel = new DockPanel();
    private Label m_label = new Label();
    private Pageable m_pageable;

    public Pager(Pageable pageable) {
        this.m_pageable = pageable;
        this.m_panel.addStyleName("pager");
        this.m_panel.add(this.createLeftPageControl(), DockPanel.WEST);
        this.m_label.addStyleName("pagerText");
        this.m_panel.add((Widget)this.m_label, DockPanel.CENTER);
        this.m_panel.add(this.createRightPageControl(), DockPanel.EAST);
        this.initWidget((Widget)this.m_panel);
        this.updateLabel();
    }

    private void updateLabel() {
        int current = this.m_pageable.getCurrentElement();
        int pageSize = this.m_pageable.getPageSize();
        int total = this.m_pageable.getElementCount();
        int first = current + 1;
        int last = Math.min(current + pageSize, total);
        this.m_label.setText(first + " to " + last + " of " + total);
    }

    private Widget createRightPageControl() {
        return new PageControl(">>", 1);
    }

    private Widget createLeftPageControl() {
        return new PageControl("<<", -1);
    }

    private int getPageSize() {
        return Math.max(1, this.m_pageable.getPageSize());
    }

    private int getMaxIndex() {
        int pages = this.m_pageable.getElementCount() / this.getPageSize();
        int extras = this.m_pageable.getElementCount() % this.getPageSize();
        if (extras == 0) {
            return (pages - 1) * this.getPageSize();
        }
        return pages * this.getPageSize();
    }

    private void adjustPage(int direction) {
        int adjustment = direction * this.getPageSize();
        int maxIndex = this.getMaxIndex();
        int newIndex = Math.max(Math.min(this.m_pageable.getCurrentElement() + adjustment, maxIndex), 0);
        this.m_pageable.setCurrentElement(newIndex);
    }

    public void update() {
        this.updateLabel();
    }

    private class PageControl
    extends Composite {
        Label m_label;
        int m_direction;

        PageControl(String text, int direction) {
            this.m_label = new Label(text);
            this.m_label.addStyleName(direction > 0 ? "pagerRight" : "pagerLeft");
            this.m_direction = direction;
            this.m_label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent sender) {
                    Pager.this.adjustPage(PageControl.this.m_direction);
                }
            });
            this.initWidget((Widget)this.m_label);
        }
    }
}

