/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.Notification;
import org.opennms.dashboard.client.NotificationView;
import org.opennms.dashboard.client.SurveillanceServiceAsync;
import org.opennms.dashboard.client.SurveillanceSet;

public class NotificationDashlet
extends Dashlet {
    private NotificationView m_view = new NotificationView(this);
    private NotificationLoader m_loader = new NotificationLoader();

    NotificationDashlet(Dashboard dashboard) {
        super(dashboard, "Notifications");
        this.setLoader(this.m_loader);
        this.setView(this.m_view);
    }

    public void setSurveillanceSet(SurveillanceSet set) {
        this.m_loader.load(set);
    }

    public void setSurveillanceService(SurveillanceServiceAsync svc) {
        this.m_loader.setSurveillanceService(svc);
    }

    class NotificationLoader
    extends DashletLoader
    implements AsyncCallback {
        private SurveillanceServiceAsync m_suveillanceService;

        NotificationLoader() {
        }

        public void load(SurveillanceSet surveillanceSet) {
            try {
                this.loading();
                this.m_suveillanceService.getNotificationsForSet(surveillanceSet, this);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataLoaded(Notification[] notifications) {
            try {
                NotificationDashlet.this.m_view.setNotifications(notifications);
            }
            finally {
                this.complete();
            }
        }

        public void setSurveillanceService(SurveillanceServiceAsync svc) {
            this.m_suveillanceService = svc;
        }

        public void onFailure(Throwable caught) {
            this.loadError(caught);
            NotificationDashlet.this.error(caught);
        }

        public void onSuccess(Object result) {
            this.onDataLoaded((Notification[])result);
        }
    }
}

