/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import org.opennms.dashboard.client.DashletLoader;

public class ListBoxCallback
implements AsyncCallback {
    private DashletLoader m_dashletLoader;
    private int m_direction = 1;
    private ListBox m_listBox;
    private String m_emptyListItemName = null;
    private String m_emptyListItemValue;
    private String m_nullListItemName;
    private String m_nullListItemValue;

    public ListBoxCallback(DashletLoader dashlet, ListBox listBox) {
        this.m_dashletLoader = dashlet;
        this.m_listBox = listBox;
    }

    public ListBox getListBox() {
        return this.m_listBox;
    }

    public void setDirection(int direction) {
        this.m_direction = direction;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public void setNullListItem(String name, String value) {
        this.m_nullListItemName = name;
        this.m_nullListItemValue = value;
    }

    public void setEmptyListItem(String name, String value) {
        this.m_emptyListItemName = name;
        this.m_emptyListItemValue = value;
    }

    public void onDataLoaded(String[][] resources) {
        this.m_listBox.clear();
        if (resources == null) {
            if (this.m_nullListItemName != null) {
                this.m_listBox.addItem(this.m_nullListItemName, this.m_nullListItemValue);
            }
        } else if (resources.length == 0) {
            if (this.m_emptyListItemName != null) {
                this.m_listBox.addItem(this.m_emptyListItemName, this.m_emptyListItemValue);
            }
        } else {
            for (int i = 0; i < resources.length; ++i) {
                this.m_listBox.addItem(resources[i][1], resources[i][0]);
            }
        }
        int itemCount = this.m_listBox.getItemCount();
        if (this.m_direction < 0 && itemCount > 0) {
            this.m_listBox.setSelectedIndex(itemCount - 1);
        } else if (this.m_direction > 0 && itemCount > 0) {
            this.m_listBox.setSelectedIndex(0);
        }
        this.m_dashletLoader.complete();
    }

    public void onFailure(Throwable caught) {
        this.m_dashletLoader.loadError(caught);
    }

    public void onSuccess(Object result) {
        this.onDataLoaded((String[][])result);
    }
}

