/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.DashletView;
import org.opennms.dashboard.client.DirectionalChangeHandler;
import org.opennms.dashboard.client.ListBoxCallback;
import org.opennms.dashboard.client.ResourceGraph;
import org.opennms.dashboard.client.SimplePageable;
import org.opennms.dashboard.client.SimplePager;
import org.opennms.dashboard.client.SurveillanceServiceAsync;
import org.opennms.dashboard.client.SurveillanceSet;
import org.opennms.dashboard.client.ValidatedListBox;

public class GraphDashlet
extends Dashlet {
    private static final int TIME_START_OFFSET = -604800;
    private static final int TIME_ROUNDING_INTERVAL = 300;
    private SurveillanceServiceAsync m_surveillanceService;
    private GraphView m_view;
    private DashletLoader m_loader = new DashletLoader();

    public GraphDashlet(Dashboard dashboard) {
        super(dashboard, "Resource Graphs");
        this.setLoader(this.m_loader);
        this.m_view = new GraphView(this);
        this.setView(this.m_view);
    }

    public void setSurveillanceService(SurveillanceServiceAsync surveillanceService) {
        this.m_surveillanceService = surveillanceService;
    }

    public void setSurveillanceSet(SurveillanceSet set) {
        this.m_view.getTopLevelResourceLoader().load(set);
    }

    public class GraphView
    extends DashletView {
        private VerticalPanel m_panel;
        private SimplePager m_pager;
        private ValidatedListBox m_topLevelResourceListBox;
        private ValidatedListBox m_childResourceListBox;
        private ValidatedListBox m_prefabGraphListBox;
        private ResourceGraph m_graph;
        private TopLevelResourceLoader m_topLevelResourceLoader;
        private ChildResourceLoader m_childResourceLoader;
        private PrefabGraphLoader m_prefabGraphLoader;
        private TopLevelResourceChangeHandler m_topLevelResourceHandler;
        private ChildResourceChangeHandler m_childResourceHandler;
        private PrefabGraphChangeHandler m_prefabGraphHandler;
        private String m_selectedResourceId;

        public GraphView(Dashlet dashlet) {
            super(dashlet);
            this.m_panel = new VerticalPanel();
            this.m_pager = new SimplePager(new SimplePageable(){

                public void adjustPage(int direction) {
                    GraphView.this.m_prefabGraphListBox.adjustSelectedValue(direction);
                }
            });
            this.m_topLevelResourceListBox = new ValidatedListBox(GraphDashlet.this);
            this.m_childResourceListBox = new ValidatedListBox(GraphDashlet.this);
            this.m_prefabGraphListBox = new ValidatedListBox(GraphDashlet.this);
            this.m_graph = new ResourceGraph();
            this.m_topLevelResourceHandler = new TopLevelResourceChangeHandler();
            this.m_childResourceHandler = new ChildResourceChangeHandler();
            this.m_prefabGraphHandler = new PrefabGraphChangeHandler();
            this.m_selectedResourceId = null;
            this.m_panel.add((Widget)this.m_topLevelResourceListBox);
            this.m_panel.add((Widget)this.m_childResourceListBox);
            this.m_panel.add((Widget)this.m_prefabGraphListBox);
            this.m_panel.add((Widget)this.m_graph);
            this.m_topLevelResourceListBox.addChangeHandler(this.m_topLevelResourceHandler);
            this.m_topLevelResourceListBox.setDirectionalChangeHandler(this.m_topLevelResourceHandler);
            this.m_childResourceListBox.addChangeHandler(this.m_childResourceHandler);
            this.m_childResourceListBox.setDirectionalChangeHandler(this.m_childResourceHandler);
            this.m_childResourceListBox.setParent(this.m_topLevelResourceListBox);
            this.m_prefabGraphListBox.addChangeHandler(this.m_prefabGraphHandler);
            this.m_prefabGraphListBox.setDirectionalChangeHandler(this.m_prefabGraphHandler);
            this.m_prefabGraphListBox.setParent(this.m_childResourceListBox);
            this.m_topLevelResourceLoader = new TopLevelResourceLoader((ListBox)this.m_topLevelResourceListBox);
            this.m_childResourceLoader = new ChildResourceLoader((ListBox)this.m_childResourceListBox);
            this.m_prefabGraphLoader = new PrefabGraphLoader((ListBox)this.m_prefabGraphListBox);
            this.initWidget((Widget)this.m_panel);
        }

        public void onDashLoad() {
            this.addToTitleBar((Widget)this.m_pager, DockPanel.CENTER);
        }

        public TopLevelResourceLoader getTopLevelResourceLoader() {
            return this.m_topLevelResourceLoader;
        }

        public class PrefabGraphChangeHandler
        extends DirectionalChangeHandler {
            public void onChange(ChangeEvent event, int direction) {
                String name = GraphDashlet.this.m_view.m_prefabGraphListBox.getSelectedValue();
                if (name == null || "".equals(name)) {
                    GraphDashlet.this.m_view.m_graph.displayNoGraph();
                } else {
                    String[] times = this.getTimes();
                    GraphDashlet.this.m_view.m_graph.setGraph(GraphView.this.m_selectedResourceId, name, times[0], times[1]);
                    this.prefetchAdjacentGraphs(times);
                }
            }

            private void prefetchAdjacentGraphs(String[] times) {
                String nextReport;
                String previousReport = GraphDashlet.this.m_view.m_prefabGraphListBox.getRelativeSelectedValue(-1);
                if (previousReport != null) {
                    GraphDashlet.this.m_view.m_graph.prefetchGraph(GraphView.this.m_selectedResourceId, previousReport, times[0], times[1]);
                }
                if ((nextReport = GraphDashlet.this.m_view.m_prefabGraphListBox.getRelativeSelectedValue(1)) != null) {
                    GraphDashlet.this.m_view.m_graph.prefetchGraph(GraphView.this.m_selectedResourceId, nextReport, times[0], times[1]);
                }
            }

            public String[] getTimes() {
                int now = (int)(System.currentTimeMillis() / 1000L);
                int end = now / 300 * 300;
                int start = end + -604800;
                return new String[]{start + "000", end + "000"};
            }
        }

        public class PrefabGraphLoader
        extends ListBoxCallback {
            public PrefabGraphLoader(ListBox listBox) {
                super(GraphDashlet.this.m_loader, listBox);
                this.setNullListItem("Nothing to graph", "");
                this.setEmptyListItem("There are no graphs to display for this resource", "");
            }

            public void load(String resourceId, int direction) {
                this.setDirection(direction);
                GraphDashlet.this.m_loader.loading("Loading data for child resource...");
                GraphDashlet.this.m_surveillanceService.getPrefabGraphs(resourceId, this);
            }

            public void onDataLoaded(String[][] prefabGraphs) {
                super.onDataLoaded(prefabGraphs);
                GraphView.this.m_prefabGraphHandler.onChange(null);
            }
        }

        public class ChildResourceChangeHandler
        extends DirectionalChangeHandler {
            public void onChange(ChangeEvent event, int direction) {
                String resourceId = GraphDashlet.this.m_view.m_childResourceListBox.getSelectedValue();
                if (resourceId == null) {
                    return;
                }
                if ("".equals(resourceId)) {
                    GraphView.this.m_selectedResourceId = GraphDashlet.this.m_view.m_topLevelResourceListBox.getSelectedValue();
                } else {
                    GraphView.this.m_selectedResourceId = resourceId;
                }
                GraphView.this.m_prefabGraphLoader.load(GraphView.this.m_selectedResourceId, direction);
            }
        }

        public class ChildResourceLoader
        extends ListBoxCallback {
            public ChildResourceLoader(ListBox listBox) {
                super(GraphDashlet.this.m_loader, listBox);
                this.setNullListItem("No parent resource", "");
                this.setEmptyListItem("Parent resource has no child resources--parent resource selected", "");
            }

            public void load(String resourceId, int direction) {
                this.setDirection(direction);
                GraphDashlet.this.m_loader.loading("Loading data for resource...");
                GraphDashlet.this.m_surveillanceService.getChildResources(resourceId, this);
            }

            public void onDataLoaded(String[][] resources) {
                super.onDataLoaded(resources);
                GraphView.this.m_childResourceHandler.onChange(null, this.getDirection());
            }
        }

        public class TopLevelResourceChangeHandler
        extends DirectionalChangeHandler {
            public void onChange(ChangeEvent event, int direction) {
                String resourceId = GraphDashlet.this.m_view.m_topLevelResourceListBox.getSelectedValue();
                if (resourceId == null) {
                    return;
                }
                GraphView.this.m_childResourceLoader.load(resourceId, direction);
            }
        }

        public class TopLevelResourceLoader
        extends ListBoxCallback {
            public TopLevelResourceLoader(ListBox listBox) {
                super(GraphDashlet.this.m_loader, listBox);
                this.setEmptyListItem("No nodes found", "");
            }

            public void load(SurveillanceSet surveillanceSet) {
                GraphDashlet.this.m_loader.loading();
                GraphDashlet.this.m_surveillanceService.getResources(surveillanceSet, this);
            }

            public void onDataLoaded(String[][] resources) {
                super.onDataLoaded(resources);
                GraphView.this.m_topLevelResourceHandler.onChange(null);
            }
        }
    }
}

