/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Alarm;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.PageableTableView;

class AlarmView
extends PageableTableView {
    private Alarm[] m_alarms;

    AlarmView(Dashlet dashlet) {
        super(dashlet, 5, new String[]{"Node", "Description", "Count", "First Time", "Last Time"});
    }

    public void setAlarms(Alarm[] alarms) {
        this.m_alarms = alarms;
        this.refresh();
    }

    protected void setRow(FlexTable table, int row, int elementIndex) {
        Alarm alarm = this.m_alarms[elementIndex];
        if (alarm.getIsDashboardRole()) {
            table.setText(row, 0, alarm.getNodeLabel());
        } else {
            table.setHTML(row, 0, "<a href=\"element/node.jsp?node=" + alarm.getNodeId() + "\">" + alarm.getNodeLabel() + "</a>");
        }
        Label label = new Label(alarm.getLogMsg());
        label.setTitle(alarm.getDescrption());
        table.setWidget(row, 1, (Widget)label);
        table.setText(row, 2, "" + alarm.getCount());
        table.setText(row, 3, alarm.getFirstEventTime().toString());
        table.setText(row, 4, alarm.getLastEventTime().toString());
        table.getRowFormatter().setStyleName(row, alarm.getSeverity());
    }

    public int getElementCount() {
        return this.m_alarms == null ? 0 : this.m_alarms.length;
    }

    protected void formatCells(FlexTable table, int row) {
        super.formatCells(table, row);
        table.getCellFormatter().addStyleName(row, 1, "bright");
    }
}

