/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.util.List;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AttributesMapperCallbackHandler;
import org.springframework.ldap.core.CollectingNameClassPairCallbackHandler;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DefaultNameClassPairMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.NameClassPairMapper;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.ldap.support.LdapUtils;

public class LdapTemplate
implements LdapOperations,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$core$LdapTemplate == null ? (class$org$springframework$ldap$core$LdapTemplate = LdapTemplate.class$("org.springframework.ldap.core.LdapTemplate")) : class$org$springframework$ldap$core$LdapTemplate));
    private static final int DEFAULT_SEARCH_SCOPE = 2;
    private static final boolean DONT_RETURN_OBJ_FLAG = false;
    private static final boolean RETURN_OBJ_FLAG = true;
    private static final String[] ALL_ATTRIBUTES = null;
    private ContextSource contextSource;
    private boolean ignorePartialResultException = false;
    static /* synthetic */ Class class$org$springframework$ldap$core$LdapTemplate;

    public LdapTemplate() {
    }

    public LdapTemplate(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ignorePartialResultException = ignore;
    }

    public void search(Name base, String filter, int searchScope, boolean returningObjFlag, NameClassPairCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag, ALL_ATTRIBUTES), handler);
    }

    public void search(String base, String filter, int searchScope, boolean returningObjFlag, NameClassPairCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag, ALL_ATTRIBUTES), handler);
    }

    public void search(final Name base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    public void search(final String base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    public void search(final Name base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler, processor);
    }

    public void search(final String base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(SearchExecutor se, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        block24: {
            DirContext ctx = this.contextSource.getReadOnlyContext();
            NamingEnumeration results = null;
            NamingException ex = null;
            try {
                processor.preProcess(ctx);
                results = se.executeSearch(ctx);
                while (results.hasMore()) {
                    NameClassPair result = (NameClassPair)results.next();
                    handler.handleNameClassPair(result);
                }
            }
            catch (NameNotFoundException e) {
                block25: {
                    try {
                        processor.postProcess(ctx);
                    }
                    catch (javax.naming.NamingException e2) {
                        if (ex == null) {
                            ex = LdapUtils.convertLdapException(e2);
                            break block25;
                        }
                        log.debug((Object)"Ignoring Exception from postProcess, main exception thrown instead", (Throwable)e2);
                    }
                }
                this.closeContextAndNamingEnumeration(ctx, results);
                if (ex != null) {
                    throw ex;
                }
            }
            catch (PartialResultException e) {
                if (this.ignorePartialResultException) {
                    log.debug((Object)"PartialResultException encountered and ignored", (Throwable)e);
                }
                ex = LdapUtils.convertLdapException(e);
            }
            catch (javax.naming.NamingException e) {
                ex = LdapUtils.convertLdapException(e);
            }
            finally {
                try {
                    processor.postProcess(ctx);
                }
                catch (javax.naming.NamingException e) {
                    if (ex == null) {
                        ex = LdapUtils.convertLdapException(e);
                    }
                    log.debug((Object)"Ignoring Exception from postProcess, main exception thrown instead", (Throwable)e);
                }
                this.closeContextAndNamingEnumeration(ctx, results);
                if (ex == null) break block24;
                throw ex;
            }
        }
    }

    public void search(SearchExecutor se, NameClassPairCallbackHandler handler) {
        this.search(se, handler, new NullDirContextProcessor());
    }

    public void search(Name base, String filter, NameClassPairCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(2, false, ALL_ATTRIBUTES), handler);
    }

    public void search(String base, String filter, NameClassPairCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(2, false, ALL_ATTRIBUTES), handler);
    }

    public List search(Name base, String filter, int searchScope, String[] attrs, AttributesMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false, attrs), mapper);
    }

    public List search(String base, String filter, int searchScope, String[] attrs, AttributesMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false, attrs), mapper);
    }

    public List search(Name base, String filter, int searchScope, AttributesMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(String base, String filter, int searchScope, AttributesMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(Name base, String filter, AttributesMapper mapper) {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, AttributesMapper mapper) {
        return this.search(base, filter, 2, mapper);
    }

    public List search(Name base, String filter, int searchScope, String[] attrs, ContextMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true, attrs), mapper);
    }

    public List search(String base, String filter, int searchScope, String[] attrs, ContextMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true, attrs), mapper);
    }

    public List search(Name base, String filter, int searchScope, ContextMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(String base, String filter, int searchScope, ContextMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(Name base, String filter, ContextMapper mapper) {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, ContextMapper mapper) {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, SearchControls controls, ContextMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(Name base, String filter, SearchControls controls, ContextMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(Name base, String filter, SearchControls controls, AttributesMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(String base, String filter, SearchControls controls, AttributesMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(String base, String filter, SearchControls controls, AttributesMapper mapper, DirContextProcessor processor) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, AttributesMapper mapper, DirContextProcessor processor) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(String base, String filter, SearchControls controls, ContextMapper mapper, DirContextProcessor processor) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, ContextMapper mapper, DirContextProcessor processor) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public void list(final String base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.list(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public void list(final Name base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.list(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public List list(String base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.list(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List list(Name base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.list(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List list(Name base) {
        return this.list(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List list(String base) {
        return this.list(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public void listBindings(final String base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.listBindings(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public void listBindings(final Name base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws javax.naming.NamingException {
                return ctx.listBindings(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public List listBindings(String base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(Name base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(String base) {
        return this.listBindings(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List listBindings(Name base) {
        return this.listBindings(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List listBindings(String base, ContextMapper mapper) {
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(Name base, ContextMapper mapper) {
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public Object executeReadOnly(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadOnlyContext();
        return this.executeWithContext(ce, ctx);
    }

    public Object executeReadWrite(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadWriteContext();
        return this.executeWithContext(ce, ctx);
    }

    private Object executeWithContext(ContextExecutor ce, DirContext ctx) {
        try {
            Object object = ce.executeWithContext(ctx);
            return object;
        }
        catch (javax.naming.NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
        finally {
            this.closeContext(ctx);
        }
    }

    public Object lookup(final Name dn) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final String dn) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final Name dn, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final String dn, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final Name dn, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public Object lookup(final String dn, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public Object lookup(final Name dn, final String[] attributes, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                return mapper.mapFromAttributes(filteredAttributes);
            }
        });
    }

    public Object lookup(final String dn, final String[] attributes, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                return mapper.mapFromAttributes(filteredAttributes);
            }
        });
    }

    public Object lookup(final Name dn, final String[] attributes, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                DirContextAdapter contextAdapter = new DirContextAdapter(filteredAttributes, dn);
                return mapper.mapFromContext(contextAdapter);
            }
        });
    }

    public Object lookup(final String dn, final String[] attributes, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                DistinguishedName name = new DistinguishedName(dn);
                DirContextAdapter contextAdapter = new DirContextAdapter(filteredAttributes, name);
                return mapper.mapFromContext(contextAdapter);
            }
        });
    }

    public void modifyAttributes(final Name dn, final ModificationItem[] mods) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void modifyAttributes(final String dn, final ModificationItem[] mods) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void bind(final Name dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void bind(final String dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void unbind(Name dn) {
        this.doUnbind(dn);
    }

    public void unbind(String dn) {
        this.doUnbind(dn);
    }

    public void unbind(Name dn, boolean recursive) {
        if (!recursive) {
            this.doUnbind(dn);
        } else {
            this.doUnbindRecursively(dn);
        }
    }

    public void unbind(String dn, boolean recursive) {
        if (!recursive) {
            this.doUnbind(dn);
        } else {
            this.doUnbindRecursively(dn);
        }
    }

    private void doUnbind(final Name dn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    private void doUnbind(final String dn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    private void doUnbindRecursively(final Name dn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) {
                LdapTemplate.this.deleteRecursively(ctx, new DistinguishedName(dn));
                return null;
            }
        });
    }

    private void doUnbindRecursively(final String dn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                LdapTemplate.this.deleteRecursively(ctx, new DistinguishedName(dn));
                return null;
            }
        });
    }

    protected void deleteRecursively(DirContext ctx, DistinguishedName name) {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                DistinguishedName childName = new DistinguishedName(binding.getName());
                childName.prepend(name);
                this.deleteRecursively(ctx, childName);
            }
            ctx.unbind(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + name + " deleted"));
            }
        }
        catch (javax.naming.NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception e) {}
        }
    }

    public void rebind(final Name dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void rebind(final String dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void rename(final Name oldDn, final Name newDn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.rename(oldDn, newDn);
                return null;
            }
        });
    }

    public void rename(final String oldDn, final String newDn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws javax.naming.NamingException {
                ctx.rename(oldDn, newDn);
                return null;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        if (this.contextSource == null) {
            throw new IllegalArgumentException("Property 'contextSource' must be set.");
        }
    }

    private void closeContextAndNamingEnumeration(DirContext ctx, NamingEnumeration results) {
        this.closeNamingEnumeration(results);
        this.closeContext(ctx);
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeNamingEnumeration(NamingEnumeration results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SearchControls getDefaultSearchControls(int searchScope, boolean returningObjFlag, String[] attrs) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setReturningObjFlag(returningObjFlag);
        controls.setReturningAttributes(attrs);
        return controls;
    }

    private void assureReturnObjFlagSet(SearchControls controls) {
        Validate.notNull((Object)controls);
        if (!controls.getReturningObjFlag()) {
            log.info((Object)"The returnObjFlag of supplied SearchControls is not set but a ContextMapper is used - setting flag to true");
            controls.setReturningObjFlag(true);
        }
    }

    public DirContextOperations lookupContext(Name dn) {
        return (DirContextOperations)this.lookup(dn);
    }

    public DirContextOperations lookupContext(String dn) {
        return (DirContextOperations)this.lookup(dn);
    }

    public void modifyAttributes(DirContextOperations ctx) {
        Name dn = ctx.getDn();
        if (dn == null || !ctx.isUpdateMode()) {
            throw new IllegalStateException("The DirContextOperations instance needs to be properly initialized.");
        }
        this.modifyAttributes(dn, ctx.getModificationItems());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MappingCollectingNameClassPairCallbackHandler
    extends CollectingNameClassPairCallbackHandler {
        private NameClassPairMapper mapper;

        public MappingCollectingNameClassPairCallbackHandler(NameClassPairMapper mapper) {
            this.mapper = mapper;
        }

        public Object getObjectFromNameClassPair(NameClassPair nameClassPair) {
            try {
                return this.mapper.mapFromNameClassPair(nameClassPair);
            }
            catch (javax.naming.NamingException e) {
                throw LdapUtils.convertLdapException(e);
            }
        }
    }

    private final class NullDirContextProcessor
    implements DirContextProcessor {
        private NullDirContextProcessor() {
        }

        public void postProcess(DirContext ctx) throws NamingException {
        }

        public void preProcess(DirContext ctx) throws NamingException {
        }
    }
}

