/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.math.BigInteger;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpMonitorStrategy
extends IPv4Monitor {
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String LESS_THAN_EQUALS = "<=";
    protected static final String GREATER_THAN_EQUALS = ">=";
    protected static final String EQUALS = "=";
    protected static final String NOT_EQUAL = "!=";
    protected static final String MATCHES = "~";

    public abstract PollStatus poll(MonitoredService var1, Map<String, Object> var2);

    public boolean meetsCriteria(SnmpValue result, String operator, String operand) {
        Boolean retVal = null;
        retVal = this.isCriteriaNull(result, operator, operand);
        if (retVal == null) {
            String value = result.toString();
            retVal = this.checkStringCriteria(operator, operand, value);
            if (retVal == null) {
                BigInteger val = BigInteger.valueOf(result.toLong());
                BigInteger intOperand = new BigInteger(operand);
                if (LESS_THAN.equals(operator)) {
                    return val.compareTo(intOperand) < 0;
                }
                if (LESS_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) <= 0;
                }
                if (GREATER_THAN.equals(operator)) {
                    return val.compareTo(intOperand) > 0;
                }
                if (GREATER_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) >= 0;
                }
                throw new IllegalArgumentException("operator " + operator + " is unknown");
            }
        } else if (retVal.booleanValue()) {
            return true;
        }
        return retVal;
    }

    private Boolean checkStringCriteria(String operator, String operand, String value) {
        Boolean retVal = null;
        if (value == null) {
            value = "";
        } else if (value.startsWith(".")) {
            value = value.substring(1);
        }
        if (operand.startsWith(".") && !MATCHES.equals(operator)) {
            operand = operand.substring(1);
        }
        if (EQUALS.equals(operator)) {
            retVal = operand.equals(value);
        } else if (NOT_EQUAL.equals(operator)) {
            retVal = !operand.equals(value);
        } else if (MATCHES.equals(operator)) {
            retVal = Pattern.compile(operand).matcher(value).find();
        }
        return retVal;
    }

    private Boolean isCriteriaNull(Object result, String operator, String operand) {
        if (result == null) {
            return Boolean.FALSE;
        }
        if (operator == null || operand == null) {
            return Boolean.TRUE;
        }
        return null;
    }
}

