/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCQueryMonitor
extends JDBCMonitor {
    private static final int OPERATOR_MAP_EQUALS = 0;
    private static final int OPERATOR_MAP_LESS_THAN = 1;
    private static final int OPERATOR_MAP_GREATER_THAN = 2;
    private static final int OPERATOR_MAP_NOT_EQUAL = 3;
    private static final int OPERATOR_MAP_LESS_THAN_EQUAL_TO = 4;
    private static final int OPERATOR_MAP_GREATER_THAN_EQUAL_TO = 5;
    private static final int QUERY_ACTION_ROW_COUNT = 0;
    private static final int QUERY_ACTION_COMPARE_STRING = 1;
    private static final int QUERY_ACTION_COMPARE_INT = 2;
    private static final int QUERY_ACTION_COMPARE_BOOLEAN = 3;
    private static Map<String, Integer> operatorMap = new HashMap<String, Integer>();
    private static Map<String, Integer> actionMap = new HashMap<String, Integer>();

    public JDBCQueryMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        operatorMap.put("=", 0);
        operatorMap.put("<", 1);
        operatorMap.put(">", 2);
        operatorMap.put("!=", 3);
        operatorMap.put("<=", 4);
        operatorMap.put(">=", 5);
        actionMap.put("row_count", 0);
        actionMap.put("compare_string", 1);
        actionMap.put("compare_int", 2);
        actionMap.put("compare_bool", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        String message;
        PollStatus ps;
        block14: {
            ps = PollStatus.unavailable();
            Statement st = null;
            String query = ParameterMap.getKeyedString(parameters, (String)"query", null);
            String action = ParameterMap.getKeyedString(parameters, (String)"action", (String)"row_count");
            String column = ParameterMap.getKeyedString(parameters, (String)"column", null);
            String operator = ParameterMap.getKeyedString(parameters, (String)"operator", (String)">=");
            message = ParameterMap.getKeyedString(parameters, (String)"message", null);
            this.log().debug("Query: " + query);
            if (query == null) {
                ps = PollStatus.unavailable((String)"Null Query, ensure query value set in poller configuration.");
                return ps;
            }
            try {
                st = con.createStatement(1005, 1007);
                ResultSet rs = st.executeQuery(query);
                rs.first();
                switch (actionMap.get(action)) {
                    case 0: {
                        rs.last();
                        int rowCount = rs.getRow();
                        int expectedRowCount = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1);
                        if (this.integerCheck(rowCount, expectedRowCount, operator)) {
                            ps = PollStatus.available();
                            break;
                        }
                        ps = PollStatus.unavailable((String)("Row Count Check Failed: " + rowCount + " " + operator + " " + expectedRowCount));
                        break;
                    }
                    case 1: {
                        String expectedString = ParameterMap.getKeyedString(parameters, (String)"operand", null);
                        String retrivedString = rs.getString(column);
                        if (expectedString.equals(retrivedString)) {
                            ps = PollStatus.available();
                            break;
                        }
                        ps = PollStatus.unavailable((String)("String Field Check Failed: Expected: " + expectedString + " Returned: " + retrivedString));
                        break;
                    }
                    case 2: {
                        int expectedInt = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1);
                        int retrivedInt = rs.getInt(column);
                        ps = this.integerCheck(retrivedInt, expectedInt, operator) ? PollStatus.available() : PollStatus.unavailable((String)("Integer Field Check Failed: " + expectedInt + " " + operator + " " + retrivedInt));
                    }
                }
                Object var18_19 = null;
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                this.closeStmt(st);
                throw throwable;
            }
            this.closeStmt(st);
            {
                break block14;
                catch (SQLException sqle) {
                    ps = PollStatus.unavailable((String)("Err: " + sqle.toString()));
                    Object var18_20 = null;
                    this.closeStmt(st);
                    break block14;
                }
                catch (Exception exp) {
                    ps = PollStatus.unavailable((String)("Err: " + exp.toString()));
                    Object var18_21 = null;
                    this.closeStmt(st);
                }
            }
        }
        if (message != null && ps.isUnavailable()) {
            ps = PollStatus.unavailable((String)(message + " " + ps.getReason()));
        }
        return ps;
    }

    private boolean integerCheck(int val, int expected, String operator) {
        switch (operatorMap.get(operator)) {
            case 0: {
                return val == expected;
            }
            case 2: {
                return val > expected;
            }
            case 5: {
                return val >= expected;
            }
            case 1: {
                return val < expected;
            }
            case 4: {
                return val <= expected;
            }
            case 3: {
                return val != expected;
            }
        }
        return false;
    }
}

