/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.DemandPollDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

final class PollerEventProcessor
implements EventListener {
    private final Poller m_poller;
    private volatile DemandPollDao m_demandPollDao;

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/internal/poller/suspendPollingService");
        ueiList.add("uei.opennms.org/internal/poller/resumePollingService");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/demandPollService");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        this.getEventManager().addEventListener(this, ueiList);
    }

    private void nodeGainedServiceHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        String whichEvent = "Unexpected Event: " + event.getUei() + ": ";
        if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            whichEvent = "nodeGainedService: ";
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            whichEvent = "resumePollingService: ";
        }
        String ipAddr = event.getInterface();
        int nodeId = (int)event.getNodeid();
        String svcName = event.getService();
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        try {
            nodeLabel = this.getPoller().getQueryManager().getNodeLabel(nodeId);
        }
        catch (Exception e) {
            log.error("Unable to retrieve nodeLabel for node " + nodeId, (Throwable)e);
        }
        this.getPoller().scheduleService(nodeId, nodeLabel, ipAddr, svcName);
    }

    private void interfaceReparentedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("interfaceReparentedHandler:  processing interfaceReparented event for " + event.getInterface());
        }
        if (event.getInterface() == null) {
            return;
        }
        String ipAddr = event.getInterface();
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldNodeID")) {
                    oldNodeIdStr = parmContent;
                    continue;
                }
                if (!parmName.equals("newNodeID")) continue;
                newNodeIdStr = parmContent;
            }
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            log.error("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        try {
            PollableNode oldNode = this.getNetwork().getNode(Integer.parseInt(oldNodeIdStr));
            if (oldNode == null) {
                log.error("interfaceReparentedHandler: Cannot locate old node " + oldNodeIdStr + " belonging to interface " + ipAddr);
                return;
            }
            PollableNode newNode = this.getNetwork().getNode(Integer.parseInt(newNodeIdStr));
            if (newNode == null) {
                log.error("interfaceReparentedHandler: Cannot locate new node " + newNodeIdStr + " to move interface to.");
                return;
            }
            PollableInterface iface = oldNode.getInterface(InetAddress.getByName(ipAddr));
            if (iface == null) {
                log.error("interfaceReparentedHandler: Cannot locate interface with ipAddr " + ipAddr + " to reparent.");
                return;
            }
            iface.reparentTo(newNode);
        }
        catch (NumberFormatException nfe) {
            log.error("interfaceReparentedHandler: failed converting old/new nodeid parm to integer, unable to process.");
            return;
        }
        catch (UnknownHostException e) {
            log.error("interfaceReparentedHandler: failed converting ipAddr " + ipAddr + " to an inet address");
            return;
        }
    }

    private void nodeRemovePollableServiceHandler(Event event) {
        InetAddress address;
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        try {
            address = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            log.error("Unable to convert " + ipAddr + " to an inet address", (Throwable)e);
            return;
        }
        if (svcName == null) {
            log.error("nodeRemovePollableServiceHandler: service name is null, ignoring event");
            return;
        }
        PollableService svc = this.getNetwork().getService(nodeId, address, svcName);
        svc.delete();
    }

    private void nodeDeletedHandler(Event event) {
        Date closeDate;
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        String sourceUei = event.getUei();
        long txNo = -1L;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (!parmName.equals("txno")) continue;
                String temp = parmContent;
                if (log.isDebugEnabled()) {
                    log.debug("nodeDeletedHandler:  parmName: " + parmName + " /parmContent: " + parmContent);
                }
                try {
                    txNo = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    log.warn("nodeDeletedHandler: Parameter txno cannot be non-numberic", (Throwable)nfe);
                    txNo = -1L;
                }
            }
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForNode(closeDate, event.getDbid(), nodeId);
        PollableNode node = this.getNetwork().getNode(nodeId);
        if (node == null) {
            log.error("Nodeid " + nodeId + " does not exist in pollable node map, unable to delete node.");
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Node does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        node.delete();
    }

    private void interfaceDeletedHandler(Event event) {
        Date closeDate;
        InetAddress addr;
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        String sourceUei = event.getUei();
        String ipAddr = event.getInterface();
        long txNo = -1L;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (!parmName.equals("txno")) continue;
                String temp = parmContent;
                if (log.isDebugEnabled()) {
                    log.debug("interfaceDeletedHandlerHandler:  parmName: " + parmName + " /parmContent: " + parmContent);
                }
                try {
                    txNo = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    log.warn("interfaceDeletedHandlerHandler: Parameter txno cannot be non-numberic", (Throwable)nfe);
                    txNo = -1L;
                }
            }
        }
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            log.error("interfaceDeletedHandler: Could not convert interface " + event.getInterface() + " to InetAddress", (Throwable)e);
            return;
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForInterface(closeDate, event.getDbid(), nodeId, ipAddr);
        PollableInterface iface = this.getNetwork().getInterface(nodeId, addr);
        if (iface == null) {
            log.error("Interface " + nodeId + "/" + event.getInterface() + " does not exist in pollable node map, unable to delete node.");
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Interface does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        iface.delete();
    }

    private void serviceDeletedHandler(Event event) {
        Date closeDate;
        InetAddress addr;
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String service = event.getService();
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            log.error("serviceDeletedHandler: Could not convert " + ipAddr + " to an InetAddress", (Throwable)e);
            return;
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForService(closeDate, event.getDbid(), nodeId, ipAddr, service);
        PollableService svc = this.getNetwork().getService(nodeId, addr, service);
        if (svc == null) {
            log.error("Interface " + nodeId + "/" + event.getInterface() + " does not exist in pollable node map, unable to delete node.");
            return;
        }
        svc.delete();
    }

    PollerEventProcessor(Poller poller) {
        this.m_poller = poller;
        this.createMessageSelectorAndSubscribe();
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("Subscribed to eventd");
        }
    }

    public void close() {
        this.getEventManager().removeEventListener(this);
    }

    private EventIpcManager getEventManager() {
        return this.getPoller().getEventManager();
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("PollerEventProcessor: received event, uei = " + event.getUei());
        }
        if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
            log.info("Reloading poller config factory and polloutages config factory");
            this.scheduledOutagesChangeHandler(log);
        } else if (event.getUei().equals("uei.opennms.org/internal/thresholdConfigChange")) {
            log.info("Reloading thresholding configuration in pollerd");
            this.thresholdsConfigChangeHandler(log);
        } else if (!event.hasNodeid()) {
            log.info("PollerEventProcessor: no database node id found, discarding event");
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("PollerEventProcessor: no interface found, cannot resume polling service, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/suspendPollingService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("PollerEventProcessor: no interface found, cannot suspend polling service, discarding event");
            } else {
                this.nodeRemovePollableServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.interfaceReparentedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted") || event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
            if (event.getNodeid() < 0L) {
                log.info("PollerEventProcessor: no node or interface found, discarding event");
            }
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("PollerEventProcessor: invalid nodeid or no interface found, discarding event");
            } else {
                this.interfaceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getInterface().length() == 0 || event.getService() == null) {
                log.info("PollerEventProcessor: invalid nodeid or no nodeinterface or service found, discarding event");
            } else {
                this.serviceDeletedHandler(event);
            }
        }
    }

    private void demandPollServiceHandler(Event e) throws InsufficientInformationException {
        EventUtils.checkNodeId(e);
        EventUtils.checkInterface(e);
        EventUtils.checkService(e);
        EventUtils.requireParm(e, "demandPollId");
        this.m_demandPollDao.get((Serializable)Integer.valueOf(EventUtils.getIntParm(e, "demandPollId", -1)));
    }

    private void scheduledOutagesChangeHandler(ThreadCategory log) {
        try {
            this.getPollerConfig().update();
            this.getPoller().getPollOutagesConfig().update();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to reload PollerConfigFactory because " + e.getMessage(), (Throwable)e);
        }
        this.getPoller().refreshServicePackages();
    }

    private void thresholdsConfigChangeHandler(ThreadCategory log) {
        this.getPoller().refreshServiceThresholds();
    }

    public String getName() {
        return "Poller:PollerEventProcessor";
    }

    private Poller getPoller() {
        return this.m_poller;
    }

    private PollerConfig getPollerConfig() {
        return this.getPoller().getPollerConfig();
    }

    private PollableNetwork getNetwork() {
        return this.getPoller().getNetwork();
    }

    private boolean isXmlRPCEnabled() {
        return this.getPollerConfig().getXmlrpc();
    }
}

