/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;

public final class CdpCacheTableEntry
extends SnmpTableEntry {
    public static final String CDP_IFINDEX = "cdpCacheIfIndex";
    public static final String CDP_DEVICEINDEX = "cdpCacheDeviceIndex";
    public static final String CDP_ADDRESS_TYPE = "cdpCacheAddressType";
    public static final String CDP_ADDRESS = "cdpCacheAddress";
    public static final String CDP_VERSION = "cdpCacheVersion";
    public static final String CDP_DEVICEID = "cdpCacheDeviceId";
    public static final String CDP_DEVICEPORT = "cdpCacheDevicePort";
    public static final String CDP_PLATFORM = "cdpPlatform";
    public static final String CDP_CAPS = "cdpCacheCapabilities";
    public static final String CDP_VTP_MGMTDOMAIN = "cdpCacheVtpMgmtDomain";
    public static final String CDP_NATIVEVLAN = "cdpCacheNatveVlan";
    public static final String CDP_DUPLEX = "cdpCacheDuplex";
    public static final String CDP_APPLIANCEID = "cdpCacheApplianceID";
    public static final String CDP_VLANID = "cdpCacheVlanID";
    public static final String CDP_POWERCONS = "cdpCachePowerConsumption";
    public static final String CDP_MTU = "cdpCacheMTU";
    public static final String CDP_SYSNAME = "cdpCacheSysName";
    public static final String CDP_SYSOBJID = "cdpCacheSysObjectID";
    public static final String CDP_PRIMARYMGMTADDR_TYPE = "cdpCachePrimaryMgmtAddressType";
    public static final String CDP_PRIMARYMGMTADDR = "cdpCachePrimaryMgmtAddress";
    public static final String CDP_SECONDARYMGMTADDR_TYPE = "cdpCacheSecondaryMgmtAddressType";
    public static final String CDP_SECONDARYMGMTADDR = "cdpCacheSecondaryMgmtAddress";
    public static final String CDP_PHYSLOC = "cdpCachePhysLocation";
    public static final String CDP_LASTCHANGE = "cdpCacheLastChange";
    public static NamedSnmpVar[] cdpCache_elemList = null;
    private boolean hasIfIndex = false;
    private static final String CDP_IFINDEX_OID = ".1.3.6.1.4.1.9.9.23.1.2.1.1.1";
    public static final String TABLE_OID = ".1.3.6.1.4.1.9.9.23.1.2.1.1";

    public CdpCacheTableEntry() {
        super(cdpCache_elemList);
    }

    public void storeResult(SnmpResult res) {
        if (!this.hasIfIndex) {
            int ifindex = res.getInstance().getSubIdAt(res.getInstance().length() - 2);
            super.storeResult(new SnmpResult(SnmpObjId.get((String)CDP_IFINDEX_OID), res.getInstance(), SnmpUtils.getValueFactory().getInt32(ifindex)));
            this.hasIfIndex = true;
        }
        super.storeResult(res);
    }

    public int getCdpCacheIfIndex() {
        Integer val = this.getInt32(CDP_IFINDEX);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getCdpCacheDeviceIndex() {
        Integer val = this.getInt32(CDP_DEVICEINDEX);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getCdpCacheAddressType() {
        Integer val = this.getInt32(CDP_ADDRESS_TYPE);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public InetAddress getCdpCacheAddress() {
        return this.getIpAddressByHexString(this.getHexString(CDP_ADDRESS));
    }

    public String getCdpCacheVersion() {
        return this.getHexString(CDP_VERSION);
    }

    public String getCdpCacheDeviceId() {
        return this.getHexString(CDP_DEVICEID);
    }

    public String getCdpCacheDevicePort() {
        return this.getDisplayString(CDP_DEVICEPORT);
    }

    public String getCdpPlatform() {
        return this.getDisplayString(CDP_PLATFORM);
    }

    private InetAddress getIpAddressByHexString(String ipaddrhexstrng) {
        long ipAddr = Long.parseLong(ipaddrhexstrng, 16);
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(ipAddr & 0xFFL);
        bytes[2] = (byte)(ipAddr >> 8 & 0xFFL);
        bytes[1] = (byte)(ipAddr >> 16 & 0xFFL);
        bytes[0] = (byte)(ipAddr >> 24 & 0xFFL);
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        cdpCache_elemList = new NamedSnmpVar[7];
        int ndx = 0;
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", CDP_IFINDEX, CDP_IFINDEX_OID, 1);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", CDP_DEVICEINDEX, ".1.3.6.1.4.1.9.9.23.1.2.1.1.2", 2);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", CDP_ADDRESS_TYPE, ".1.3.6.1.4.1.9.9.23.1.2.1.1.3", 3);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", CDP_ADDRESS, ".1.3.6.1.4.1.9.9.23.1.2.1.1.4", 4);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", CDP_VERSION, ".1.3.6.1.4.1.9.9.23.1.2.1.1.5", 5);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", CDP_DEVICEID, ".1.3.6.1.4.1.9.9.23.1.2.1.1.6", 6);
        CdpCacheTableEntry.cdpCache_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", CDP_DEVICEPORT, ".1.3.6.1.4.1.9.9.23.1.2.1.1.7", 7);
    }
}

