/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.ArrayList;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

final class LinkdEventProcessor
implements EventListener,
InitializingBean {
    private EventIpcManager m_eventMgr;

    LinkdEventProcessor() {
    }

    public void close() {
        this.getEventMgr().removeEventListener(this);
    }

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeRegainedService");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        this.getEventMgr().addEventListener(this, ueiList);
    }

    public String getName() {
        return "Linkd:LinkdEventProcessor";
    }

    private Linkd getLinkd() {
        return Linkd.getInstance();
    }

    private void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().deleteNode((int)event.getNodeid());
    }

    private void handleInterfaceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterfaceOrIfIndex(event);
        int ifIndex = -1;
        if (event.hasIfIndex()) {
            ifIndex = event.getIfIndex();
        }
        this.getLinkd().deleteInterface((int)event.getNodeid(), event.getInterface(), ifIndex);
    }

    private void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().scheduleNodeCollection((int)event.getNodeid());
    }

    private void handleNodeLostService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().suspendNodeCollection((int)event.getNodeid());
    }

    private void handleRegainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().wakeUpNodeCollection((int)event.getNodeid());
    }

    public void onEvent(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        try {
            int eventid = event.getDbid();
            String eventUei = event.getUei();
            if (eventUei == null) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info("onEvent: Received event " + eventid + " UEI " + eventUei);
            }
            if (eventUei.equals("uei.opennms.org/nodes/nodeDeleted")) {
                if (log.isInfoEnabled()) {
                    log.info("onEvent: calling handleNodeDeleted for event " + eventid);
                }
                this.handleNodeDeleted(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
                if (log.isInfoEnabled()) {
                    log.info("onEvent: calling handleInterfaceDeleted for event " + eventid);
                }
                this.handleInterfaceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLostService") && event.getService().equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info("onEvent: calling handleNodeLostService for event " + eventid);
                }
                this.handleNodeLostService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeRegainedService") && event.getService().equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info("onEvent: calling handleRegainedService for event " + eventid);
                }
                this.handleRegainedService(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/nodeGainedService") && event.getService().equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info("onEvent: calling handleNodeGainedService for event " + eventid);
                }
                this.handleNodeGainedService(event);
            }
        }
        catch (InsufficientInformationException ex) {
            log.info("onEvent: insufficient information in event, discarding it: " + ex.getMessage());
        }
        catch (Throwable t) {
            log.error("onEvent: operation failed for event: " + event.getUei() + ", exception: " + t.getMessage(), t);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"must set the eventMgr property");
        this.createMessageSelectorAndSubscribe();
    }

    public EventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(EventIpcManager mgr) {
        this.m_eventMgr = mgr;
    }
}

