/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OutageManagerConfig;
import org.opennms.netmgt.config.outage.OutageConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class OutageManagerConfigFactory
implements OutageManagerConfig {
    private static OutageManagerConfigFactory m_singleton = null;
    private OutageConfiguration m_config;
    private static boolean m_loaded = false;

    private OutageManagerConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.m_config = (OutageConfiguration)CastorUtils.unmarshal(OutageConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OUTAGE_MANAGER_CONFIG_FILE_NAME);
        m_singleton = new OutageManagerConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        OutageManagerConfigFactory.init();
    }

    public static synchronized OutageManagerConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized int getWriters() {
        return this.m_config.getWriters();
    }

    public synchronized String getGetNextOutageID() {
        return this.m_config.getGetNextOutageID();
    }

    public synchronized boolean deletePropagation() {
        boolean propagation = true;
        String deletePropagation = this.m_config.getDeletePropagation();
        if (deletePropagation != null && deletePropagation.equals("false")) {
            propagation = false;
        }
        return propagation;
    }
}

