/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.OnmsSnmpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpIfData {
    private int m_nodeId;
    private boolean m_collectionEnabled;
    private int m_ifIndex;
    private int m_ifType;
    private String m_rrdLabel;
    private String m_ifAlias;
    private Map<String, String> m_attributes;

    public SnmpIfData(OnmsSnmpInterface snmpIface) {
        this.m_nodeId = this.nullSafeUnbox(snmpIface.getNode().getId(), -1);
        this.m_collectionEnabled = snmpIface.isCollectionEnabled();
        this.m_ifIndex = this.nullSafeUnbox(snmpIface.getIfIndex(), -1);
        this.m_ifType = this.nullSafeUnbox(snmpIface.getIfType(), -1);
        this.m_rrdLabel = snmpIface.computeLabelForRRD();
        this.m_ifAlias = snmpIface.getIfAlias();
        this.m_attributes = new HashMap<String, String>();
        this.m_attributes.put("ipaddr", snmpIface.getIpAddress());
        this.m_attributes.put("snmpphysaddr", snmpIface.getPhysAddr());
        this.m_attributes.put("snmpifindex", Integer.toString(this.m_ifIndex));
        this.m_attributes.put("snmpifdescr", snmpIface.getIfDescr());
        this.m_attributes.put("snmpiftype", Integer.toString(this.m_ifType));
        this.m_attributes.put("snmpifname", snmpIface.getIfName());
        this.m_attributes.put("snmpifadminstatus", Integer.toString(this.nullSafeUnbox(snmpIface.getIfAdminStatus(), -1)));
        this.m_attributes.put("snmpifoperstatus", Integer.toString(this.nullSafeUnbox(snmpIface.getIfOperStatus(), -1)));
        this.m_attributes.put("snmpifspeed", Long.toString(this.nullSafeUnbox(snmpIface.getIfSpeed(), -1)));
        this.m_attributes.put("snmpifalias", this.m_ifAlias);
    }

    int nullSafeUnbox(Integer num, int dflt) {
        return num == null ? dflt : num;
    }

    long nullSafeUnbox(Long num, int dflt) {
        return num == null ? dflt : num.intValue();
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public boolean isCollectionEnabled() {
        return this.m_collectionEnabled;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }

    public int getIfType() {
        return this.m_ifType;
    }

    public String getLabelForRRD() {
        return this.m_rrdLabel;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public Map<String, String> getAttribtuesMap() {
        return this.m_attributes;
    }
}

