/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.charts;

import java.awt.Color;
import java.awt.Paint;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.charts.CustomSeriesColors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeveritySeriesColors
implements CustomSeriesColors {
    @Override
    public Paint getPaint(Comparable<?> cat) {
        int sev = 0;
        String severity = cat.toString();
        Color converted = Color.BLACK;
        try {
            sev = Integer.parseInt(severity);
        }
        catch (NumberFormatException e) {
            SeveritySeriesColors.log().warn("Problem converting severity: " + severity + " to an int value.");
        }
        switch (sev) {
            case 0: {
                break;
            }
            case 1: {
                converted = Color.GRAY;
                break;
            }
            case 2: {
                converted = Color.WHITE;
                break;
            }
            case 3: {
                converted = Color.GREEN;
                break;
            }
            case 4: {
                converted = Color.CYAN;
                break;
            }
            case 5: {
                converted = Color.YELLOW;
                break;
            }
            case 6: {
                converted = Color.ORANGE;
                break;
            }
            case 7: {
                converted = Color.RED;
            }
        }
        return converted;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SeveritySeriesColors.class);
    }
}

