/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "SNMP";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            return this.getValue(agentConfig, DEFAULT_OID) != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        if (val == null || val.isNull() || val.isEndOfMib() || val.isError()) {
            return null;
        }
        return val.toString();
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        block17: {
            try {
                String oid = ParameterMap.getKeyedString(qualifiers, (String)"vbname", (String)DEFAULT_OID);
                SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
                String expectedValue = null;
                String isTable = null;
                if (qualifiers != null) {
                    if (qualifiers.get("port") != null) {
                        int port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)agentConfig.getPort());
                        agentConfig.setPort(port);
                    }
                    if (qualifiers.get("timeout") != null) {
                        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)agentConfig.getTimeout());
                        agentConfig.setTimeout(timeout);
                    }
                    if (qualifiers.get("retry") != null) {
                        int retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)agentConfig.getRetries());
                        agentConfig.setRetries(retry);
                    }
                    if (qualifiers.get("force version") != null) {
                        String version = (String)qualifiers.get("force version");
                        if (version.equalsIgnoreCase("snmpv1")) {
                            agentConfig.setVersion(1);
                        } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                            agentConfig.setVersion(2);
                        } else if (version.equalsIgnoreCase("snmpv3")) {
                            agentConfig.setVersion(3);
                        }
                    }
                    if (qualifiers.get("vbvalue") != null) {
                        expectedValue = (String)qualifiers.get("vbvalue");
                    }
                    if (qualifiers.get("table") != null) {
                        isTable = (String)qualifiers.get("table");
                    }
                }
                if (isTable != null && isTable.equalsIgnoreCase("true")) {
                    SnmpObjId snmpObjId = SnmpObjId.get((String)oid);
                    Map table = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"SnmpPlugin", (SnmpObjId)snmpObjId);
                    for (Map.Entry e : table.entrySet()) {
                        if (!((SnmpValue)e.getValue()).toString().equals(expectedValue)) continue;
                        return true;
                    }
                    break block17;
                }
                String retrievedValue = this.getValue(agentConfig, oid);
                if (retrievedValue != null && expectedValue != null) {
                    return Pattern.compile(expectedValue).matcher(retrievedValue).find();
                }
                return retrievedValue != null;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return false;
    }
}

