/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.io.PrintStream;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.config.Configuration;
import net.jradius.session.JRadiusSession;

public abstract class JRadiusRequest
extends JRadiusEvent {
    private JRadiusSession session;

    public abstract int getReturnValue();

    public abstract void setReturnValue(int var1);

    public abstract AttributeList getConfigItems();

    public abstract RadiusPacket[] getPackets();

    public abstract void setConfigItems(AttributeList var1);

    public abstract void setPackets(RadiusPacket[] var1);

    public JRadiusSession getSession() {
        return this.session;
    }

    public void setSession(JRadiusSession session) {
        this.session = session;
    }

    public String getSessionKey() {
        if (this.session != null) {
            return this.session.getSessionKey();
        }
        return null;
    }

    public RadiusPacket getRequestPacket() {
        RadiusPacket[] p = this.getPackets();
        if (p.length == 0) {
            throw new RuntimeException("No Request packet in JRadiusRequest");
        }
        return p[0];
    }

    public RadiusPacket getReplyPacket() throws RadiusException {
        RadiusPacket[] p = this.getPackets();
        if (p.length < 2) {
            throw new RadiusException("No Reply packet in JRadiusRequest");
        }
        return p[1];
    }

    public void setReplyPacket(RadiusPacket np) {
        RadiusPacket[] p = this.getPackets();
        p[1] = np;
    }

    public boolean hasReplyPacket() {
        return this.getPackets().length == 2;
    }

    public boolean isAccountingRequest() {
        try {
            return this.getRequestPacket() instanceof AccountingRequest;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addReplyAttribute(RadiusAttribute a) {
        if (this.hasReplyPacket()) {
            try {
                this.getReplyPacket().addAttribute(a);
            }
            catch (RadiusException radiusException) {}
        } else {
            this.getConfigItems().add(a);
        }
    }

    public void printDebugInfo(PrintStream out) {
        if (!Configuration.isDebug()) {
            return;
        }
        RadiusPacket[] rp = this.getPackets();
        out.println("\n>>> packets in request from \"" + this.getSender() + "\":");
        for (int i = 0; i < rp.length; ++i) {
            if (rp[i] == null) continue;
            System.out.println("--- packet " + (i + 1) + " of " + rp.length);
            System.out.println(rp[i].toString());
        }
        out.println("Configuration Items:");
        out.println(this.getConfigItems().toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append(" requester = ").append(this.getSender());
        sb.append(", type = ").append(this.getTypeString());
        sb.append(" }");
        return sb.toString();
    }
}

