/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.LinkedHashMap;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessReject;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.AccountingResponse;
import net.jradius.packet.AccountingStatus;
import net.jradius.packet.CoAACK;
import net.jradius.packet.CoANAK;
import net.jradius.packet.CoARequest;
import net.jradius.packet.DHCPAck;
import net.jradius.packet.DHCPDecline;
import net.jradius.packet.DHCPDiscover;
import net.jradius.packet.DHCPForceRenew;
import net.jradius.packet.DHCPInform;
import net.jradius.packet.DHCPNack;
import net.jradius.packet.DHCPOffer;
import net.jradius.packet.DHCPRelease;
import net.jradius.packet.DHCPRequest;
import net.jradius.packet.DisconnectACK;
import net.jradius.packet.DisconnectNAK;
import net.jradius.packet.DisconnectRequest;
import net.jradius.packet.NullPacket;
import net.jradius.packet.PasswordAck;
import net.jradius.packet.PasswordReject;
import net.jradius.packet.PasswordRequest;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;

public class PacketFactory {
    private static LinkedHashMap codeMap = new LinkedHashMap();

    public static RadiusPacket parse(DatagramPacket dp) throws RadiusException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dp.getData());
        DataInputStream input = new DataInputStream(bais);
        RadiusPacket rp = null;
        try {
            int code = RadiusFormat.readUnsignedByte(input);
            int identifier = RadiusFormat.readUnsignedByte(input);
            Class c = (Class)codeMap.get(new Integer(code));
            if (c == null) {
                throw new RadiusException("bad radius code");
            }
            int length = RadiusFormat.readUnsignedShort(input);
            byte[] bAuthenticator = new byte[16];
            input.readFully(bAuthenticator);
            byte[] bAttributes = new byte[length - 20];
            input.readFully(bAttributes);
            try {
                rp = (RadiusPacket)c.newInstance();
                rp.setIdentifier(identifier);
                rp.setAuthenticator(bAuthenticator);
                RadiusFormat.setAttributeBytes(rp, bAttributes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rp;
    }

    private static RadiusPacket parsePacket(DataInputStream input) throws RadiusException, IOException {
        RadiusPacket rp = null;
        int code = (int)RadiusFormat.readUnsignedInt(input);
        int identifier = (int)RadiusFormat.readUnsignedInt(input);
        Class c = code == 0 ? NullPacket.class : (Class)codeMap.get(new Integer(code));
        if (c == null) {
            throw new RadiusException("bad radius packet type: " + code);
        }
        int length = input.readInt();
        byte[] bAttributes = new byte[length];
        input.readFully(bAttributes);
        try {
            rp = (RadiusPacket)c.newInstance();
            rp.setIdentifier(identifier);
            FreeRadiusFormat.setAttributeBytes(rp, bAttributes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rp;
    }

    public static RadiusPacket[] parse(DataInputStream input, int packetCount) throws RadiusException {
        RadiusPacket[] rp = new RadiusPacket[packetCount];
        try {
            for (int i = 0; i < packetCount; ++i) {
                rp[i] = PacketFactory.parsePacket(input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rp;
    }

    static {
        codeMap.put(new Integer(1), AccessRequest.class);
        codeMap.put(new Integer(2), AccessAccept.class);
        codeMap.put(new Integer(3), AccessReject.class);
        codeMap.put(new Integer(4), AccountingRequest.class);
        codeMap.put(new Integer(5), AccountingResponse.class);
        codeMap.put(new Integer(6), AccountingStatus.class);
        codeMap.put(new Integer(7), PasswordRequest.class);
        codeMap.put(new Integer(8), PasswordAck.class);
        codeMap.put(new Integer(9), PasswordReject.class);
        codeMap.put(new Integer(11), AccessChallenge.class);
        codeMap.put(new Integer(40), DisconnectRequest.class);
        codeMap.put(new Integer(41), DisconnectACK.class);
        codeMap.put(new Integer(42), DisconnectNAK.class);
        codeMap.put(new Integer(43), CoARequest.class);
        codeMap.put(new Integer(44), CoAACK.class);
        codeMap.put(new Integer(45), CoANAK.class);
        codeMap.put(new Integer(1025), DHCPDiscover.class);
        codeMap.put(new Integer(1026), DHCPOffer.class);
        codeMap.put(new Integer(1027), DHCPRequest.class);
        codeMap.put(new Integer(1028), DHCPDecline.class);
        codeMap.put(new Integer(1029), DHCPAck.class);
        codeMap.put(new Integer(1030), DHCPNack.class);
        codeMap.put(new Integer(1031), DHCPRelease.class);
        codeMap.put(new Integer(1032), DHCPInform.class);
        codeMap.put(new Integer(1033), DHCPForceRenew.class);
    }
}

