/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import net.jradius.client.RadiusClient;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.value.NamedValue;
import net.jradius.util.RadiusUtils;

public class AccountingRequest
extends RadiusRequest {
    public static final byte CODE = 4;
    private static final long serialVersionUID = 4L;
    public static final int ACCT_STATUS_START = 1;
    public static final int ACCT_STATUS_STOP = 2;
    public static final int ACCT_STATUS_INTERIM = 3;
    public static final int ACCT_STATUS_ACCOUNTING_ON = 7;
    public static final int ACCT_STATUS_ACCOUNTING_OFF = 8;

    public AccountingRequest() {
        this.code = 4;
    }

    public AccountingRequest(RadiusClient client) {
        super(client);
        this.code = 4;
    }

    public AccountingRequest(AttributeList attributes) {
        super(attributes);
        this.code = 4;
    }

    public AccountingRequest(RadiusClient client, AttributeList attributes) {
        super(client, attributes);
        this.code = 4;
    }

    public int getAccountingStatusType() {
        Long i = (Long)this.getAttributeValue(40L);
        if (i != null) {
            return i.intValue();
        }
        return -1;
    }

    public void setAccountingStatusType(int type) {
        RadiusAttribute a = AttributeFactory.newAttribute(40L, null);
        NamedValue s = (NamedValue)a.getValue();
        s.setValue(new Long(type));
        this.overwriteAttribute(a);
    }

    public byte[] createAuthenticator(byte[] attributes, String sharedSecret) {
        this.authenticator = RadiusUtils.makeRFC2866RequestAuthenticator(sharedSecret, (byte)this.getCode(), (byte)this.getIdentifier(), attributes.length + 20, attributes);
        return this.authenticator;
    }
}

